import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    SelectColor CS;
    ControlPanel CONSTRAINTS,DEBUG,ACTION,METHOD;
    ControlPanelColor DISPLAY;
    ListenSquare GO,STOP;
    SelectInteger ANNEAL;
    HillClimber HILLC;
    Searcher SEAR;
    String[] STR=new String[4];
    SelectIntegerKeyboard SOLID;

     public ControlCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(M,0,248,399,50);
	 GO=new ListenSquare(250,90,40,20);
	 STOP=new ListenSquare(250,110,40,20);
	 HILLC=new HillClimber();
	 SEAR=new Searcher();
	 HILLC.halt=true;
	 SEAR.halt=true;
	 ANNEAL=new SelectInteger(200,0,40,20,2,0,60,2);
	 SOLID=new SelectIntegerKeyboard(200,40,40,20,72);
	 setPanels();
	 for(int i=0;i<4;++i) STR[i]="";
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawString(g);
   }

    
    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       String[] ConstraintString={"fold count upper","fold count lower","solution constraints"};
       int[] ConstraintState={0,0};
        CONSTRAINTS=new ControlPanel(C0,ConstraintString,ConstraintState,2);

	String[] ActionString={"select domain","local swap","action"};
       int[] ActionState={1,0};
        ACTION=new ControlPanel(C0,ActionString,ActionState,2);

	String[] MethodString={"hill climbing","depth first search","method"};
       int[] MethodState={1,0};
        METHOD=new ControlPanel(C0,MethodString,MethodState,2);



	String[] DisplayString={"backg",
				"edge color",
				"color0",
                                "color1",
                                "color2",
				"flower grid",
				"flower domain",
                                "display"};
	Color[] DisplayColor={new Color(255,255,255),
			      new Color(0,50,255,150),
                              new Color(40,80,255),
			      new Color(255,255,255),
			      new Color(0,0,0),
			      new Color(0,50,255,150),
			      Color.white};

	int[] DisplayState={1,1,1,1,0,0,1};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,7,DisplayColor);
	
	
    }
    

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(170,0,170));
         g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawString(Graphics2D g) {
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,14));
	for(int i=0;i<4;++i)  g.drawString(STR[i],140,170+20*i);
    }
    
    public void drawControls(Graphics2D g) { 
      CS.render(g);
      int mode=METHOD.mode;
      if(mode==0) {
         if(HILLC.halt==true) GO.render(g,new Color(0,180,0));
         if(HILLC.halt==false) STOP.render(g,new Color(180,0,0));
	 CONSTRAINTS.render(g,290,140,105);
      }
      if(mode==1) {
         if(SEAR.halt==true) GO.render(g,new Color(0,180,0));
         if(SEAR.halt==false) STOP.render(g,new Color(180,0,0));
      }
      METHOD.render(g,0,0,120);
      DISPLAY.render(g,0,55,120);
      ACTION.render(g,0,185,120);
      ANNEAL.render(g,Color.blue,Color.white,Color.white);
      SOLID.render(g,Color.black,Color.blue,Color.yellow,Color.white);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.setColor(Color.white);
      g.drawString("algorithm tolerance",ANNEAL.x+ANNEAL.w+30,ANNEAL.y+14);
      g.drawString("fold bound",(int)(SOLID.x+2*SOLID.w+30),(int)(SOLID.y+14));

      
    }

    public void doGo() {
	if(SEAR.halt==false) return;
	if(HILLC.halt==false) return;
	int mode=METHOD.mode;
	if(mode==1) {
	   SEAR=new Searcher(this.M);
	   new Thread(SEAR).start();
	}

	if(mode==0) {
	    HILLC=new HillClimber(this.M);
	    new Thread(HILLC).start();
	}
    }
    
    public void mouseClicked(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	if(GO.inside(J.X)==1) doGo();
	if(STOP.inside(J.X)==1) {
	    HILLC.halt=true;
	    SEAR.halt=true;
	}
	if(STOP.inside(J.X)==1) SEAR.halt=true;
	CONSTRAINTS.toggle(J.X);
	ANNEAL.modify(J.X);
	SOLID.increment(J.X);
	ACTION.switchMode(J.X);
	METHOD.switchMode(J.X);
	DISPLAY.process(J.X,CS.C);
	repaint();
	M.P.repaint();
	M.F.repaint();
    }

    public int foldConstraint() {
	int a=CONSTRAINTS.L[0].on;
	int b=CONSTRAINTS.L[1].on;
	if(a+b==0) return 0;
	if(a+b==2) return 3;
	if(a==1) return 1;
	if(b==1) return 2;
	return 0;
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
    public void mouseDragged(MouseEvent e) {}

    public void keyTyped(KeyEvent e) {
	SOLID.modify(e);
	repaint();
    }
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}

}

 
