import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class DomainMap {

    /**This class does the symmetries of the tiling*/


    public static PolygonWrapper doMap(int k0,PolygonWrapper[] DOMAIN,PolygonWrapper K) {
	if(k0==0) return K;
	Complex[] Z={new Complex(0,0),DOMAIN[0].z[1],DOMAIN[0].z[2],DOMAIN[1].z[0]};
	if(k0==1) {
	    Complex zz=Complex.plus(Z[1],Z[2]);
	    return translate(zz,K);
	}
	if(k0==2) {
	    Complex zz=Complex.plus(Z[1],Z[2]);
	    zz=zz=new Complex(-zz.x,-zz.y);
	    return translate(zz,K);
	}
	
	int k=k0-3;
	int k1=k%4;
	int k2=(k-k1)/4;
	Complex z=Z[k1];
	if(k2==0) return rotateAbout1(z,K);
	if(k2==1) return rotateAbout2(z,K);
	return K;
    }


    public static PolygonWrapper rotateAbout1(Complex z,PolygonWrapper P) {
	PolygonWrapper Q=new PolygonWrapper(P);
	for(int i=0;i<Q.count;++i) Q.z[i]=rotateAbout1(z,P.z[i]);
	return Q;
    }
    
    public static PolygonWrapper rotateAbout2(Complex z,PolygonWrapper P) {
	PolygonWrapper Q=new PolygonWrapper(P);
	for(int i=0;i<Q.count;++i) Q.z[i]=rotateAbout2(z,P.z[i]);
	return Q;
    }
    
    public static PolygonWrapper translate(Complex z,PolygonWrapper P) {
	PolygonWrapper Q=new PolygonWrapper(P);
	for(int i=0;i<Q.count;++i) Q.z[i]=Complex.plus(z,P.z[i]);
	return Q;
    }
    
    

    public static Complex rotateAbout1(Complex z,Complex w) {
	Complex q=Complex.eis(0,1);
	q=Complex.times(q,q);
	Complex w1=Complex.minus(w,z);
	Complex w2=Complex.times(w1,q);
	Complex w3=Complex.plus(w2,z);
	return w3;
    }

    public static Complex rotateAbout2(Complex z,Complex w) {
	Complex q=Complex.eis(0,1);
	q=Complex.times(q,q);
	q=Complex.times(q,q);
	Complex w1=Complex.minus(w,z);
	Complex w2=Complex.times(w1,q);
	Complex w3=Complex.plus(w2,z);
	return w3;
    }


}


