import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class Flower {

    public static PolygonWrapper domain(int a,int b) {
	Complex[] z=new Complex[4];
	z[0]=new Complex(0,0);
	z[1]=lattice(a,b);
	z[3]=Complex.times(alpha(),z[1]);
	z[2]=trans(a,b,0);
	PolygonWrapper X=new PolygonWrapper(4,z);
	return X;
    }

    public static Complex trans(int a,int b,int k) {
	Complex w=alpha();
	Complex z1=lattice(a,b);
	Complex z2=Complex.times(w,z1);
	Complex z3=Complex.plus(z1,z2);
	for(int i=0;i<k;++i) {
	   z3=Complex.times(z3,w);
	}
	return z3;
    }

    public static int gaussLength(int[] g) {
	int count=0;
	boolean test=true;
	while(test==true) {
	    g=slowGauss(g);
	    if(g==null) test=false;
	    ++count;
	}
	return count;
    }

    public static int[] slowGauss(int[] g) {
	int a=g[0];
	int b=g[1];
	
	if(b==1) return null;
	if(b-a<a) {
	    int[] c={b-a,a,0};
	    return c;
	}
	int[] c={a,b-a,1};
	return c;
    }

    public static void translate(PolygonWrapper[][] X,Complex z) {
	for(int i=0;i<X.length;++i) {
	    for(int j=0;j<X[i].length;++j) {
		translate(X[i][j],z);
	    }
	}
    }
    
    public static void translate(PolygonWrapper P,Complex z) {
	for(int k=0;k<P.count;++k) {
	   P.z[k]=P.z[k].minus(z);
	}
    }


    public static void transform(PolygonWrapper[][] X,int a,int b,int q0,int q1) {
	Complex w=alpha(q0);
	for(int i=0;i<X.length;++i) {
	    for(int j=0;j<X[i].length;++j) {
		transform(X[i][j],a,b,q0,q1);
	    }
	}
    }

    public static void transform(PolygonWrapper P,int a,int b,int q0,int q1) {
	Complex w=alpha(q0);
	for(int k=0;k<P.count;++k) {
	   P.z[k]=Complex.times(w,P.z[k]);
	   if(q1==1) P.z[k]=P.z[k].conjugate();
	}
    }


    

    public static PolygonWrapper[][] flower(int a,int b,int q1,int q2) {
	PolygonWrapper[][] X=flower(a,b);
	//Complex z1=trans(a,b,q1);
	//	Complex z2=trans(a,b,q2);

	Complex z1=trans(a,b,0);
	Complex z2=trans(a,b,1);
	Complex w=Complex.plus(z1.scale(q1),z2.scale(q2));

	
	for(int i=0;i<X.length;++i) {
	    for(int j=0;j<X[i].length;++j) {
		for(int k=0;k<X[i][j].count;++k) {
		    //X[i][j].z[k]=Complex.plus(X[i][j].z[k],z1);
		    //X[i][j].z[k]=Complex.plus(X[i][j].z[k],z2);
		    X[i][j].z[k]=Complex.plus(X[i][j].z[k],w);
		}
	    }
	}
	return X;
    }

		



    

     public static PolygonWrapper[][] flower(int a,int b) {
	int[] f={a,b};
	int t=gaussLength(f);
	PolygonWrapper[][] X=new PolygonWrapper[t+2][6];
	for(int i=0;i<6;++i) X[0][i]=cap(a,b,i);
	X[1]=trapNecklace(f[0],f[1]);
	for(int i=2;i<t+1;++i) {
	    f=slowGauss(f);
	    X[i]=trapNecklace(f[0],f[1]);
	    X[i]=fix(X[i],X[i-1]);
	}
	for(int i=0;i<6;++i) X[t+1][i]=core(i);
	return X;
    }

    public static PolygonWrapper[] fix(PolygonWrapper[] Y,PolygonWrapper[] X) {
	boolean test=match(Y,X);
	if(test==true) return Y;
	return conjugate(Y);
    }

    public static PolygonWrapper[] conjugate(PolygonWrapper[] Y) {
	PolygonWrapper[] Z=new PolygonWrapper[6];
	for(int i=0;i<6;++i) Z[i]=Y[i].conjugate();
	return Z;
    }
    
    public static boolean match(PolygonWrapper[] Y,PolygonWrapper[] X) {
	Complex z=Y[0].z[0];
	for(int i=0;i<6;++i) {
	    for(int j=0;j<4;++j) {
		double d=Complex.dist(z,X[i].z[j]);
		if(d<.00000001) return true;
	    }
	}
	return false;
    }
	  
    public static PolygonWrapper[] trapNecklace(int a,int b) {
	PolygonWrapper[] X=new PolygonWrapper[6];
	for(int q=0;q<6;++q) X[q]=trap(a,b,q);
	return X;
    }

    public static PolygonWrapper trap(int a,int b,int k) {
	Complex w=alpha();
	Complex[] Z=trap(a,b);
	for(int i=0;i<k;++i) {
	    for(int j=0;j<4;++j) {
		Z[j]=Complex.times(w,Z[j]);
	    }
	}
	PolygonWrapper X=new PolygonWrapper(4,Z);
	X.type=0;
	return X;
    }

    public static PolygonWrapper cap(int a,int b,int k) {
	Complex w=alpha();
	Complex[] Z=cap(a,b);
	for(int i=0;i<k;++i) {
	    for(int j=0;j<4;++j) {
		Z[j]=Complex.times(w,Z[j]);
	    }
	}
	PolygonWrapper X=new PolygonWrapper(4,Z);
	X.type=2;
	return X;
    }


    
    public static Complex[] trap(int a,int b) {
	Complex[] Z=new Complex[4];
	Complex w=alpha();
	Z[0]=lattice(a,b);
	Z[1]=lattice(a-b,b);
	Z[2]=lattice(2*a-b,b-a);
	Z[3]=lattice(a,b-a);
	return Z;
    }
    
    public static Complex[] cap(int a,int b) {
	Complex[] Z=new Complex[4];
	Complex w=alpha();
	Z[0]=lattice(a,b);
	Z[1]=lattice(a-b,b);
	Z[2]=lattice(2*a-b,b-a);
	Z[2]=Complex.minus(Z[1].scale(2),Z[2]);
	Z[3]=Complex.plus(Z[0],Z[2]);
	Z[3]=Complex.minus(Z[3],Z[1]);
       	return Z;
    }

    public static PolygonWrapper core(int k) {
	Complex[] Z=core();
	Complex w=alpha();
	for(int i=0;i<k;++i) {
	    for(int j=0;j<3;++j) {
		Z[j]=Complex.times(w,Z[j]);
	    }
	}
	PolygonWrapper X=new PolygonWrapper(3,Z);
	X.type=1;
	return X;
    }

    public static Complex[] core() {
	Complex[] z=new Complex[3];
	z[0]=new Complex(0,0);
	z[1]=new Complex(1,0);
	z[2]=alpha();
	return z;
    }
    

    public static Complex lattice(int a,int b) {
	Complex z=alpha();
	return Complex.plus(new Complex(a,0),Complex.times(z,new Complex(b,0)));
    }

    public static Complex alpha(int q) {
	Complex z=new Complex(1,0);
	Complex w=alpha();
	for(int i=0;i<q;++i) z=Complex.times(z,w);
	return z;
    }
    
    public static Complex alpha() {
	double x=1.0/2;
	double y=Math.sqrt(3)/2;
	return new Complex(x,y);
    }
    

    
}

