import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class FlowerCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    ListenSquare CONTROL;
    ShapeEntryRational S;
    Output OUT;
    ListenSquare EXPORT;
    ListenSquare GO,STOP;
    Animator AN;
    HorizontalSlider SPEED;
    ControlPanel VIEW;
    int[] STATE=new int[4];

     public FlowerCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);
	 setScales(250,350,50);
	 CONTROL=new ListenSquare(0,0,150,90);
	 S=new ShapeEntryRational(5,5);
	 S.I[0].val=32;
	 S.I[1].val=41;
	 EXPORT=new ListenSquare(100,5,44,20);
	 GO=new ListenSquare(160,5,35,20);
	 STOP=new ListenSquare(160,30,35,20);
	 AN=new Animator();
	 AN.halt=true;
	 SPEED=new HorizontalSlider(50,60,300,20,200,Color.blue,"speed");
	 setPanels();
	 STATE[0]=0;
	 STATE[1]=0;
	 STATE[2]=0;
	 STATE[3]=0;

     }

    
    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       String[] ViewString={"plain","spiral","triad","motion"};
       int[] ViewState={0,1,0};
        VIEW=new ControlPanel(C0,ViewString,ViewState,3);
	VIEW.mode=1;

    }
    


    
    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawFlower(g);
      if(M.C.DISPLAY.L[5].on==1) drawGrid(g);
      if(M.C.DISPLAY.L[6].on==1) drawDomain(g);
      drawControls(g);
      drawStats(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(200,200,200));
        g.fillRect(0,0,getWidth(),getHeight());
    }

    public static int convert(double d) {
	int e=(int)(Math.floor(d+.1));
	return e;
    }
    
    public void drawStats(Graphics2D g) {
	int[] aa=S.getVal();
	int a=aa[0];
	int b=aa[1];
	if(isSuitable(a,b)==false) return;
	double[] F=IsoRatio.isoRatioTotal(a,b);
	Integer I1=new Integer(convert(F[0]));
	Integer I2=new Integer(convert(F[1]));
	Double D=new Double(F[2]);
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	String[] STR=new String[3];
	STR[0]="faces "+I2.toString();
	STR[1]="fold count "+I1.toString();
	STR[2]="EIR "+D.toString();
	g.setColor(Color.white);
	for(int i=0;i<3;++i) g.drawString(STR[i],210,17+18*i);
    }

    
    public void drawControls(Graphics2D g) {
	CONTROL.w=this.getWidth();
	CONTROL.render(g,Color.black);
	S.render(g);
	EXPORT.render(g,Color.white);
	g.setColor(Color.black);
	g.drawString("export",(int)(EXPORT.x+5),(int)(EXPORT.y+15));
	if(AN.halt==true) {
	    GO.render(g,new Color(0,180,0));
	    g.setColor(Color.black);
	    g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
	}
	if(AN.halt==false) {
	    STOP.render(g,new Color(220,0,0));
            g.setColor(Color.black);
	    g.drawString("stop",(int)(STOP.x+5),(int)(STOP.y+15));
	}
	g.setColor(Color.black);
	SPEED.render(g);
	VIEW.render(g,400,5,70);
    }


    public void drawGrid(Graphics2D g) {
	Color C=M.C.DISPLAY.M[5].C;
	double h=Math.sqrt(3)/2;
	for(int q=0;q<3;++q) {
	    Complex w=Flower.alpha(q);
	    for(int i=-100;i<100;++i) {
	       Complex z1=new Complex(-100,i*h);
	       Complex z2=new Complex(100,i*h);
	       z1=Complex.times(z1,w);
	       z2=Complex.times(z2,w);
	       drawLine(g,z1,z2,C);
	    }
	}
    }

    public void drawLine(Graphics2D g,Complex z1,Complex z2,Color C) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(z1.x,z1.y);
	p.lineTo(z2.x,z2.y);
	p=transform(p);
	g.setColor(C);
	g.draw(p);
    }
    

    public void drawDomain(Graphics2D g) {
	int[] aa=S.getVal();
	int a=aa[0];
	int b=aa[1];
	if(isSuitable(a,b)==false) return;
	PolygonWrapper P=Flower.domain(a,b);

	if(VIEW.mode==1) Flower.transform(P,a,b,STATE[0],STATE[1]);
	
	if(VIEW.mode==2) {
	   Complex z=new Complex(a,b);
	   Flower.translate(P,z);
	}
	Path2D.Double p=P.toPath();
	p=transform(p);
	g.setStroke(new BasicStroke(4));
	g.setColor(Color.black);
	g.draw(p);
	g.setStroke(new BasicStroke(2));
	g.setColor(Color.white);
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public void drawFlower(Graphics2D g) {
	int[] aa=S.getVal();
	int a=aa[0];
	int b=aa[1];
	if(isSuitable(a,b)==false) return;
	int N=4;
	drawFlower1(g,a,b);
	for(int i=-N+1;i<N;++i) {
	    for(int j=-N+1;j<N;++j) {
		drawFlower2(g,a,b,i,j);
	    }
	}
    }

    public boolean isSuitable(int a,int b) {
	if(a==0) return false;
	if(a>=b) return false;
	int s=MathRational.greatestCommonDivisor(a,b);
	if(s>1) return false;
	return true;
    }


    public void drawFlower1(Graphics2D g,int a,int b) {
	Color[] C={M.C.DISPLAY.M[3].C,M.C.DISPLAY.M[4].C};
	PolygonWrapper[][] X=Flower.flower(a,b);

	if(VIEW.mode==1) Flower.transform(X,a,b,STATE[0],STATE[1]);
	
	if(VIEW.mode==2) {
	   Complex z=new Complex(a,b);
	   Flower.translate(X,z);
	}
	
	for(int i=0;i<X.length;++i) {
	    if(i<X.length-1) render(g,C[i%2],X[i]);
	    else renderCore(g,C,X[i]);
	}
    }
    

    public void drawFlower2(Graphics2D g,int a,int b,int k1,int k2) {
	Color[] C={M.C.DISPLAY.M[3].C,M.C.DISPLAY.M[4].C};
 	PolygonWrapper[][] X=Flower.flower(a,b,k1,k2);

	if(VIEW.mode==1) Flower.transform(X,a,b,STATE[0],STATE[1]);

	if(VIEW.mode==2) {
	   Complex z=new Complex(a,b);
	   Flower.translate(X,z);
	}

	for(int i=0;i<X.length;++i) {
	    if(i<X.length-1) render(g,C[i%2],X[i]);
	    else renderCore(g,C,X[i]);
	}
    }
    

    public void render(Graphics2D g,Color C,PolygonWrapper[] X) {
	for(int q=0;q<6;++q) {
	    Path2D.Double p=X[q].toPath();
	    p=transform(p);
	    g.setColor(C);
	    g.fill(p);
	    g.draw(p);
	}
    }


    public void renderCore(Graphics2D g,Color[] C,PolygonWrapper[] X) {
	for(int q=0;q<6;++q) {
	    Path2D.Double p=X[q].toPath();
	    p=transform(p);
	    g.setColor(C[q%2]);
	    g.fill(p);
	    g.draw(p);
	}
    }

    public void doExport() {
	OUT=new Output("Output/graph");
	exportFlower();
    }

    /**controls*/
    
    public void doControls(MouseEvent e) {
	S.processMouse(e);
	MouseData J=MouseData.process(e);
	if(EXPORT.inside(J.X)==1) doExport();
	if(GO.inside(J.X)==1) doGo();
	if(STOP.inside(J.X)==1) AN.halt=true;
	VIEW.switchMode(J.X);
    }
    

    /**export routines*/

    public void exportFlower() {
	int[] aa=S.getVal();
	int a=aa[0];
	int b=aa[1];
	if(isSuitable(a,b)==false) return;
	
	exportFlower1(a,b);
	for(int i=0;i<6;++i) {
	    for(int j=i;j<6;++j) {
		exportFlower2(a,b,i,j);
	    }
	}
    }

    public void exportFlower1(int a,int b) {
	Color[] C={M.C.DISPLAY.M[3].C,M.C.DISPLAY.M[4].C};
	PolygonWrapper[][] X=Flower.flower(a,b);
	for(int i=0;i<X.length;++i) {
	    if(i<X.length-1) export(C[i%2],X[i]);
	    else exportCore(C,X[i]);
	}
    }
    

    public void exportFlower2(int a,int b,int k1,int k2) {
	Color[] C={M.C.DISPLAY.M[3].C,M.C.DISPLAY.M[4].C};
	PolygonWrapper[][] X=Flower.flower(a,b,k1,k2);
	for(int i=0;i<X.length;++i) {
	    if(i<X.length-1) export(C[i%2],X[i]);
	    else exportCore(C,X[i]);
	}
    }

    public void export(Color C,PolygonWrapper[] X) {
	for(int q=0;q<6;++q) {
	    Path2D.Double p=X[q].toPath();
	    OUT.polyWrite(p,C,C);
	}
    }

    public void exportCore(Color[] C,PolygonWrapper[] X) {
	for(int q=0;q<6;++q) {
	    Path2D.Double p=X[q].toPath();
	    OUT.polyWrite(p,C[q%2],C[q%2]);
	}
    }


    public void doGo() {
	if(AN.halt==false) return;
	AN=new Animator(this.M);
	new Thread(AN).start();
    }
    

    
    
    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
	SPEED.activate(J.X);
    }
    
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    doControls(e);
	    repaint();
	    if(SPEED.ACTIVE==1) SPEED.configure(J.X);
	    return;
	}
	
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	
	repaint();
	//doTest1();
    }

    public void doTest1() {

	for(int i=0;i<128;++i) {
	    int[] b=IsoRatio.binary(7,i);
	    int[] A=IsoRatio.tree(b);
	    for(int j=0;j<7;++j) {
		if(b[j]==0) {
		  int[] b2=IsoRatio.swap(b,j);
		  int[] A2=IsoRatio.tree(b2);
		  double r1=IsoRatio.isoRatio(A[0],A[1]);
		  double r2=IsoRatio.isoRatio(A2[0],A2[1]);
		  double r3=r1-r2;
		  if(r3<0) {
		      System.out.println(A[0]+" "+A[1]);
		      System.out.println(A2[0]+" "+A2[1]);
		      System.out.println("---------");
		  }
		}
	    }
	}
    }

    public void doTest2() {
	IsoRatio.fibonacciConjecture(1,1,500);
	IsoRatio.fibonacciConjecture(1,2,500);
	IsoRatio.fibonacciConjecture(2,3,500);
	IsoRatio.fibonacciConjecture(3,5,500);
	IsoRatio.fibonacciConjecture(5,8,500);
	IsoRatio.fibonacciConjecture(8,13,500);
	IsoRatio.fibonacciConjecture(13,21,500);
	IsoRatio.fibonacciConjecture(21,34,500);
	IsoRatio.fibonacciConjecture(34,55,500);
	IsoRatio.fibonacciConjecture(55,89,500);
    }

    




    
    public void mouseDragged(MouseEvent e) {
	   MouseData J=MouseData.process(e);
	   if(SPEED.ACTIVE==1) SPEED.configure(J.X);
	   repaint();
	}

    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
    
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   

    public void keyTyped(KeyEvent e) {
	S.processKey(e);
	repaint();
    }
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}

}

