import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

public class IsoRatio {


    /**converts the numbers 0,...,2^k to binary **/

    public static int[] binary(int k,int n) {
	int[] x=new int[k];
	int m=n;
	for(int count=0;count<k;++count) {
	    x[k-1-count]=m%2;
	    m=(m-x[k-1-count])/2;
	}
	return(x);
    }


    public static int[] tree(int[] b) {
	int p=1;
	int q=2;
	int p0=0;
	int q0=0;
	for(int i=0;i<b.length;++i) {
	    if(b[i]==0) {
		p0=p;
		q0=p+q;
	    }
	      if(b[i]==1) {
		p0=q;
		q0=p+q;
	    }
	      p=p0;
	      q=q0;
	}
	int[] P={p,q};
	return P;
    }
		
    public static int[] swap(int[] b,int k) {
	int[] c=new int[b.length];
	for(int i=0;i<b.length;++i) {
	    if(i!=k) c[i]=b[i];
	    else c[i]=1-b[i];
	}
	return c;
    }

    public static void fibonacciConjecture(int p,int q,int lim) {
	double S=isoRatio(p,q);
	System.out.println("start "+p+" "+q+" "+lim);
        for(int i=1;i<lim;++i) {
	  for(int j=i+1;j<lim;++j) {
	    int s=MathRational.greatestCommonDivisor(i,j);
	    if((j>=q)&&(s==1)) {
		double r=S-isoRatio(i,j);
		if(r>0) System.out.println(i+" "+j+" "+r);
	    }
	  }
	}
	System.out.println("end");
    }


    public static double isoRatio(int a,int b) {
	double[] x=isoRatioTotal(a,b);
	return x[2];
    }

    public static double[] isoRatioTotal(int a,int b) {
	PolygonWrapper[][] X=Flower.flower(a,b);
	return isoRatioTotal(X);

    }

    public static double[] isoRatioTotal(PolygonWrapper[][] X) {
	double e=edge(X);
	double f=face(X);
	double r=(e*e)/f;
	double[] I={e,f,r};
	return I;
    }
    

    public static double face(PolygonWrapper[][] X) {
	double d=0;
	for(int i=0;i<X.length;++i) {
	    for(int j=0;j<X[i].length;++j) {
		d=d+face(X[i][j]);
	    }
	}
	return d;
    }
	
    public static double edge(PolygonWrapper[][] X) {
	double d=0;
	for(int i=0;i<X.length;++i) {
	    for(int j=0;j<X[i].length;++j) {
		d=d+edge(X[i][j]);
	    }
	}
	return d+1;
    }

    public static double face(PolygonWrapper X) {
	if(X.type==0) return face0(X);
	if(X.type==1) return face1(X);
	return face2(X);
    }

    public static double face0(PolygonWrapper X) {
	double b=Complex.dist(X.z[0],X.z[1]);
	double a=Complex.dist(X.z[1],X.z[2]);
	double d=2*a*b-a*a;
	return d/3;
    }
    
    public static double face1(PolygonWrapper X) {
	return 1.0/3;
    }
    
    public static double face2(PolygonWrapper X) {
	double b=Complex.dist(X.z[0],X.z[1]);
	double a=Complex.dist(X.z[1],X.z[2]);
	double d=2*a*b;
	return d/6;
    }
    
    public static double edge(PolygonWrapper X) {
	if(X.type==0) return edge0(X);
	if(X.type==1) return edge1(X);
	return edge2(X);
    }

    public static double edge0(PolygonWrapper X) {
	double b=Complex.dist(X.z[0],X.z[1]);
	double a=Complex.dist(X.z[1],X.z[2]);
	double d=2*a+b+(b-a);
	return d/6;
    }
    
    public static double edge1(PolygonWrapper X) {
	return 1.0/6;
    }
    
    public static double edge2(PolygonWrapper X) {
	double b=Complex.dist(X.z[0],X.z[1]);
	double a=Complex.dist(X.z[1],X.z[2]);
	double d=2*a+2*b;
	return d/12;
    }
    
    
}

