import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


/**This is wrapper class for a list of points in the
   plane.  The main routine in this class is
   taking the convex hull of a finite set of points.
**/


public class PolygonWrapper {
    Complex[] z=new Complex[500];
    int count;
    int type;
    int index;
    
    /**Constructors**/
    public PolygonWrapper() {}

    public PolygonWrapper(PolygonWrapper P) {
	for(int i=0;i<P.count;++i) z[i]=new Complex(P.z[i]);
	count=P.count;
	type=P.type;
    }


    public PolygonWrapper(int cc,Complex[] zz) {
	this.count=cc;
	for(int i=0;i<cc;++i) {
             z[i]=new Complex(zz[i]);
	}
    }


    /**specialized routines*/

    public static PolygonWrapper baseTriangle(int q) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=3;
	P.z[0]=new Complex(0,0);
	P.z[1]=new Complex(1,0);
	P.z[2]=new Complex(.5,Math.sqrt(3)/2);
	if(q==1) P.z[2].y=-P.z[2].y;
	return P;
    }

    public static PolygonWrapper gridTriangle(int q,int u,int v) {
	PolygonWrapper P=baseTriangle(q);
	Complex W=Complex.eis(u,v);
	for(int i=0;i<3;++i) P.z[i]=Complex.plus(P.z[i],W);
	return P;
    }


    /**converting to a path*/

    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(z[0].x,z[0].y);
	for(int i=0;i<count;++i) {
	    gp.lineTo(z[i].x,z[i].y);
	}
	gp.closePath();
	return(gp);
    }

    /**center*/
    public Complex center() {
	Complex w=new Complex(0,0);
	for(int i=0;i<count;++i) {
	    w=Complex.plus(w,z[i]);
	}
	w=w.scale(1.0/count);
	return w;
    }

    /**vertex test*/
    public boolean isVertex(Complex w) {
	for(int i=0;i<count;++i) {
	    if(Complex.dist(z[i],w)<.000000001) return true;
	}
	return false;
    }

    public PolygonWrapper contract(double t) {
	PolygonWrapper P=new PolygonWrapper();
	P.count=this.count;
	Complex c=this.center();
	for(int i=0;i<this.count;++i) {
	    P.z[i]=Complex.plus(c.scale(t),this.z[i].scale(1-t));
	}
	return P;
    }

    public PolygonWrapper conjugate() {
	PolygonWrapper P=new PolygonWrapper(this);
	for(int i=0;i<count;++i) P.z[i]=z[i].conjugate();
	return P;
    }

    /**printout**/

    public void print() {
	System.out.println("count "+count);
	for(int i=0;i<count;++i) z[i].print();
    }

}

