
/**This class does the depth-first search*/

public class Searcher implements Runnable {
    Manager M;
    int[][] F;
    int N;
    boolean halt;

    public Searcher() {
	halt=true;
    }

    public Searcher(Manager MM) {
	this.M=MM;
	halt=false;
	this.F=ListHelp.trim(M.P.SOLV.F,M.P.SOLV.COUNT);
	for(int j=0;j<3;++j) F[j]=ListHelp.trim(F[j],2);
	this.N=M.P.SOLV.MAX+1;
    }

    public void run() {
	clearString();
	int[][] LIST=new int[24][1];
	for(int i=0;i<24;++i) LIST[i][0]=23-i;
	int CURRENT=23;

	System.out.println("------");
	
	while(halt==false) {
	    int[] S=LIST[CURRENT];
	    sendToPic(S);
	    M.P.repaint();
	    M.C.repaint();

	    int t=F.length-S.length;
	    System.out.println("working "+CURRENT+" "+t);
	    int[] exclude={};
	    int quality=TreeSearch.isGood(F,N,S,exclude);

	    if((CURRENT==0)||(quality==2)) {
		halt=true;
		sendToControl(S);
	    }

	    if(quality==1) {
		   LIST=augment(LIST,CURRENT);
		   CURRENT=CURRENT+23;
	    }

	    if(quality==0) --CURRENT;
	}
	M.P.repaint();
	M.C.repaint();
	
    }


    public int[][] augment(int[][] LIST,int CURRENT) {
	int n=LIST.length;
	int[][] LIST2=new int[n+23][0];
	for(int i=0;i<CURRENT;++i) LIST2[i]=ListHelp.copy(LIST[i]);
	for(int i=0;i<24;++i) LIST2[CURRENT+i]=ListHelp.append(LIST[CURRENT],23-i);
	return LIST2;
    }

    public void clearString() {
	for(int i=0;i<4;++i) M.C.STR[i]="";
    }

    public void sendToPic(int[] S) {
	for(int i=0;i<S.length;++i) {
	    int c=S[i];
	    int[] T=TreeSearch.solution(c);
	    for(int j=0;j<T.length;++j) {
		M.P.SOL[F[i][j]]=1+T[j];
	    }
	}
    }
    
    public void sendToControl(int[] S) {
	
	M.C.STR[0]="Solved!";
	
	int[] c={0,0};
	for(int i=0;i<N;++i) {
	    int t=M.P.SOL[i]-1;
	    ++c[t];
	}
	
	Integer FACE=new Integer(N);
	Integer BF=new Integer(c[0]);
	Integer WF=new Integer(c[1]);
	M.C.STR[1]="faces "+FACE.toString()+"  ("+BF.toString()+" "+WF.toString()+")";

	int fold=0;
        for(int ii=3;ii<S.length;++ii) {
	   int[] T=TreeSearch.solution(S[ii]);
	   for(int i=0;i<T.length;++i) {
	      int j=(i+1)%T.length;
	      if(T[i]!=T[j]) ++fold;
	   }
	}
	fold=fold/2+3;
	Integer FOLD=new Integer(fold);
	M.C.STR[2]="fold count: "+FOLD.toString();

	double eir = 1.0*fold*fold/N;
	Double EIR=new Double(eir);
	M.C.STR[3]="EIR: "+EIR.toString();
    }


    

}




