import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    SelectColor CS;
    ControlPanel ACTION,DEBUG;
    ControlPanelColor DISPLAY;
    ListenSquare GO,STOP;
    SelectInteger ANNEAL;
    Animator AN;
    String[] STR=new String[2];
    SelectIntegerKeyboard SOLID;

     public ControlCanvas() {
	 addMouseListener(this);
	 addKeyListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(M,0,248,499,50);
	 GO=new ListenSquare(240,0,40,20);
	 STOP=new ListenSquare(240,28,40,20);
	 AN=new Animator();
	 AN.halt=true;
	 ANNEAL=new SelectInteger(300,3,40,20,0,0,10,1);
	 SOLID=new SelectIntegerKeyboard(300,30,40,20,50);
	 setPanels();
	 STR[0]="";
	 STR[1]="";
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawString(g);
   }

    
    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       String[] ConstraintString={"fix cone points","degree 0","fold upper bound","solution constraints"};
       int[] ConstraintState={0,1,0};
        ACTION=new ControlPanel(C0,ConstraintString,ConstraintState,3);

	String[] DebugString={"off","flowers","face neighbors","shapes","debug mode"};
	int[] DebugState={1,0,0,0};
        DEBUG=new ControlPanel(C0,DebugString,DebugState,4);


	String[] DisplayString={"backg",
				"color0",
                                "color1",
                                "color2",
				"grid",
				"control points",
				"vertices",
				"cursor",
                                "display"};
	Color[] DisplayColor={new Color(0,0,0),
                              new Color(50,100,255),
			      new Color(0,0,0),
			      new Color(255,255,255),
			      new Color(255,200,0),
			      new Color(0,0,0),
			      new Color(255,255,255),
			      new Color(255,150,0)};

	int[] DisplayState={1,1,1,1,1,1,0,1};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,8,DisplayColor);
	
	
    }
    

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(170,0,170));
         g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawString(Graphics2D g) {
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString(STR[0],140,210);
	g.drawString(STR[1],140,230);
    }
    
    public void drawControls(Graphics2D g) { 
      CS.render(g);
      if(AN.halt==true) GO.render(g,new Color(0,180,0));
      if(AN.halt==false) STOP.render(g,new Color(180,0,0));
      ACTION.render(g,0,0,120);
      DISPLAY.render(g,0,85,120);
      DEBUG.render(g,125,0,100);
      ANNEAL.render(g,Color.blue,Color.white,Color.white);
      SOLID.render(g,Color.black,Color.blue,Color.yellow,Color.white);
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.setColor(Color.white);
      g.drawString("algorithm tolerance",ANNEAL.x+ANNEAL.w+30,ANNEAL.y+14);
      g.drawString("solidity bound",(int)(SOLID.x+SOLID.w+80),(int)(SOLID.y+14));

      
    }

    public void doGo() {
	if(AN.halt==false) return;
	AN=new Animator(this.M);
	new Thread(AN).start();
    }
    
    public void mouseClicked(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	if(GO.inside(J.X)==1) doGo();
	if(STOP.inside(J.X)==1) AN.halt=true;
	ACTION.toggle(J.X);
	DEBUG.switchMode(J.X);
	ANNEAL.modify(J.X);
	SOLID.increment(J.X);
	DISPLAY.process(J.X,CS.C);
	repaint();
	M.P.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	repaint();
	M.P.repaint();
     } 

    public void keyTyped(KeyEvent e) {
	SOLID.modify(e);
	repaint();
    }
	public void keyPressed(KeyEvent e) {}
        public void keyReleased(KeyEvent e) {}

}

