
/**This short class animates the polyhedron exchange display**/

public class HillClimber implements Runnable {
    Manager M;
    boolean halt;
    Solver[] MEM=new Solver[100];
    int COUNT=0;

    public HillClimber() {}

    public HillClimber(Manager MM) {
	this.M=MM;
    }

    public void run() {
	halt=false;
	resetPictureWindow();
	M.C.STR[0]="Working";
	M.C.repaint();

	Solver SOL=new Solver(M.P.SOLV);
	boolean test=SOL.isBad();
	if(test==true) {
	    sendFail();
	    halt=true;
	    return;
	}
	SOL.initialGuess();
	
	while(halt==false) {
	    SOL.ANNEAL=M.C.ANNEAL.val;
	    SOL.SOLID_MAX=M.C.SOLID.val;
	    SOL.MODE[1]=M.C.foldConstraint();
	    SOL=SOL.improve();
	    sendSol(SOL);
	    if(SOL.ERROR<.000001) halt=true;
	}
	
	SOL.print(false);
	setString(SOL);
	M.P.SOLV=new Solver(SOL);
	M.C.repaint();
	M.P.repaint();
    }

    public void resetPictureWindow() {
	for(int i=0;i<1000;++i) M.P.SOL[i]=0;
    }

    public void sendSol(Solver SOL) {
	for(int i=0;i<SOL.MAX+1;++i) {
	    M.P.SOL[i]=SOL.SOL[i];
	}
 	Double e=new Double(SOL.ERROR);
	M.C.STR[0]="Working";
	M.C.STR[1]="Error: "+e.toString();
  	Integer ee=new Integer(SOL.SOLID);
	M.C.STR[2]="fold count: "+ee.toString();

	int[] c=SOL.solCount();
	int F=c[0]+c[1]+c[2];
        int f=SOL.SOLID;
	double r=1.0*f*f/F;
	Double R=new Double(r);
	M.C.STR[3]="EIR "+R.toString();
	
	M.C.repaint();
	M.P.repaint();
    }

    public void sendFail() {
	M.C.STR[0]="graph not correctly computed";
	M.C.STR[1]="no output from solver";
	M.C.STR[2]="";
	M.C.STR[3]="";
	M.C.repaint();
	M.P.repaint();
    }



    public void setString(Solver SOL) {
	if(SOL.ERROR>0) {
  	    M.C.STR[0]="failed";
	    return;
	}
	int[] c=SOL.solCount();
	Integer a0=new Integer(c[1]+c[2]);
	Integer a1=new Integer(c[1]);
	Integer a2=new Integer(c[2]);
	M.C.STR[0]="Solved!";
	M.C.STR[1]="faces "+a0.toString()+" ("+a1.toString()+"   "+a2.toString()+")";
    }
    
}



