import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Solver SOLV;
    PolygonWrapper[] TRI=new PolygonWrapper[16000];
    PolygonWrapper[] DOMAIN=new PolygonWrapper[2];
    PolygonWrapper[] HEX=new PolygonWrapper[2];
    int[] FACE=new int[1000];
    int[][] VERTEX=new int[1000][2];
    int[][] FLOWER=new int[1000][6];
    int[] SOL=new int[1000];
    int[] SELECT=new int[2];
    Color COLOR;
    int A,B;
    int COUNT,VCOUNT;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 makeTriangles();
	 SOLV=new Solver();
	 computeFlowers();
	 SELECT[0]=0;
	 SELECT[1]=3;
	 setDomain0(Complex.eis(2,3));
	 setDomain1(Complex.eis(1,2));
	 A=3;B=5;
	 computeVertices();
	 setScales(160,450,90);
     }


    public void makeTriangles() {
	COUNT=0;
	int count=0;
	for(int i=-40;i<40;++i) {
	    for(int j=0;j<40;++j) {
		TRI[count]=PolygonWrapper.gridTriangle(0,i,j);
		TRI[count].index=count;
		++count;
		TRI[count]=PolygonWrapper.gridTriangle(1,i,j);
		TRI[count].index=count;
		++count;
	    }
	}
	COUNT=count;
     }
    
    public void computeVertices() {
	VCOUNT=0;
  	int count=0;
	for(int i=-40;i<40;++i) {
	    for(int j=0;j<40;++j) {
		Complex w=Complex.eis(i,j);
		boolean test=isDomainVertex(w);
		if(test==true) {
		    VERTEX[count][0]=i;
		    VERTEX[count][1]=j;
		    ++count;
		}
	    }
	}
	VCOUNT=count;
    }
    
    public boolean isDomainVertex(Complex w) {
	for(int i=0;i<2;++i) {
	    if(HEX[i].interiorPoint(w)==true) return false;
	}
	    
	for(int i=0;i<3;++i) {
       	    if(Complex.dist(w,DOMAIN[0].z[i])<.0001) {
		return true;
	    }
	}
	
	PolygonWrapper Q0=DOMAIN[0].contract(-.0001);
	PolygonWrapper Q1=DOMAIN[1].contract(+.0001);
	Path2D.Double p0=Q0.toPath();
	Path2D.Double p1=Q1.toPath();
	if(p0.contains(w.x,w.y)) return true;
	if(p1.contains(w.x,w.y)) return true;
	return false;
    }





    public void setDomain0(Complex z) {
	DOMAIN[0]=new PolygonWrapper();
	DOMAIN[1]=new PolygonWrapper();
	DOMAIN[0].count=3;
	DOMAIN[1].count=3;
	Complex w=Complex.eis(0,1);
	DOMAIN[0].z[0]=Complex.eis(0,0);
	DOMAIN[0].z[1]=new Complex(z);
	DOMAIN[0].z[2]=Complex.times(DOMAIN[0].z[1],w);

  	DOMAIN[1].z[0]=Complex.plus(DOMAIN[0].z[1],DOMAIN[0].z[2]);
	DOMAIN[1].z[1]=new Complex(DOMAIN[0].z[2]);
	DOMAIN[1].z[2]=new Complex(DOMAIN[0].z[1]);
    }


    public void setDomain1(Complex z) {
	boolean test=DOMAIN[0].interiorPoint(z);
	if(test==false) return;
	HEX[0]=new PolygonWrapper();
	HEX[1]=new PolygonWrapper();
	HEX[0].count=6;
	HEX[1].count=6;
 	Complex w=DOMAIN[1].z[0];
	HEX[0].z[0]=new Complex(z);
	for(int i=1;i<6;++i) {
	    HEX[0].z[i]=Complex.times(HEX[0].z[i-1],Complex.eis(0,1));
	}
	for(int i=0;i<6;++i) {
	    HEX[1].z[i]=Complex.plus(HEX[0].z[i],w);
	}
    }

    public void setDomain01() {
	Complex w=DOMAIN[1].z[0];
	for(int i=0;i<6;++i) {
	    HEX[1].z[i]=Complex.plus(HEX[0].z[i],w);
	}
    }

    


    public void setDomain() {
	if(SOURCE.y<0) return;
	int[] xx=recognizeSource();
	int x0=xx[0];
	int y0=xx[1];
	Complex w=Complex.eis(x0,y0);
	int m=M.C.HEX.mode;
	if(m==0) {
	    setDomain0(w);
	    setDomain01();
	}
	if(m==1) setDomain1(w);
	if(m==2) SELECT=xx;
	computeVertices();
	computeFlowers();
    }



    public int[] recognizeSource() {
	int x0=0;
	int y0=0;
	double min=100000;
	for(int i=-40;i<40;++i) {
	    for(int j=-40;j<40;++j) {
		double d=Complex.dist(SOURCE,Complex.eis(i,j));
		if(d<min) {
		    min=d;
		    x0=i;
		    y0=j;
		}
	    }
	}
	int[] xx={x0,y0};
	A=x0;
	B=y0;
	return xx;
    }




    /***this computes the flowers**/
    public void computeFlowers() {
	int[] face=new int[1000];
	int count=0;
	for(int i=0;i<VCOUNT;++i) {
	    FLOWER[i]=getFlower(VERTEX[i][0],VERTEX[i][1]);

	    if(FLOWER[i].length==6) {
		FLOWER[i]=reorderList(FLOWER[i]);
	    }

	    
	    for(int j=0;j<FLOWER[i].length;++j) {
   		face[count]=FLOWER[i][j];
		++count;
	    }
	}
	FACE=ListHelp.irredundantNonzero(face);

	for(int i=0;i<VCOUNT;++i) {
	    for(int j=0;j<FLOWER[i].length;++j) {
		int k=ListHelp.lookup(FLOWER[i][j],FACE);
		FLOWER[i][j]=k;
	    }
	}
	
	SOLV=new Solver(FLOWER,VCOUNT);

	SOLV.print(false);
    }




    

    
    public  int[] getFlower(int a,int b) {
	Complex z=Complex.eis(a,b);
	boolean test=isDomainVertex(z);
	if(test==false) return null;
	int[] list=new int[7];
	int count=0;
	
	for(int i=0;i<COUNT;++i) {
	    Complex c=TRI[i].center();
	    test=isDomainVertex(c);
	    if(test==true) {
		boolean test1=false;
		for(int q=0;q<7;++q) {
   		    Complex zz=basicMap(q,z);
	            boolean test2=TRI[i].isVertex(zz);
		    if(test2==true) test1=true;
		}
	        if(test1==true) {
		   list[count]=i;
		   ++count;
		}
	    }
	}

	int[] list2=new int[count];
	for(int i=0;i<count;++i) list2[i]=list[i];
	return list2;
    }

    public int[] reorderList(int[] LIST0) {
	int[] LIST1=new int[LIST0.length];
	int i0=-1;
	int i1=LIST0[0];
	int count=1;
	LIST1[0]=i1;

	for(int i=1;i<LIST0.length;++i) {
	    int i2=getNext(i0,i1,LIST0);
	    LIST1[count]=i2;
	    i0=i1;
	    i1=i2;
	    ++count;
	}
	if(ListHelp.onList(-1,LIST1,6)==true) return LIST0;
	return LIST1;
    }


    public int getNext(int i0,int i1,int[] LIST) {
	for(int i=0;i<LIST.length;++i) {
  	    double test=orbifoldDistance(i1,LIST[i]);
	    if((test>.5)&&(test<.6)&&(LIST[i]!=i0)) return LIST[i];
	}
	return -1;
    }


    public double orbifoldDistance(int i0,int i1) {
	if(i0==-1) return 10000;
	if(i1==-1) return 10000;
       	Complex c0=TRI[i0].center();
	Complex c1=TRI[i1].center();
	double dist=100000;
	for(int q=0;q<7;++q) {
	   Complex c2=basicMap(q,c1);
           double test=Complex.dist(c0,c2);
	   if(test<dist) dist=test;
	}
	return dist;
    }
    

    public Complex basicMap(int q,Complex z) {
	if(q==0) return z;
	
	if(q==1) {
	    Complex w1=Complex.reflectInLine(DOMAIN[0].z[1],DOMAIN[0].z[2],z);
	    Complex w2=Complex.reflectInLine(DOMAIN[0].z[0],DOMAIN[0].z[1],w1);
	    return w2;
	}
	if(q==2) {
	    Complex w1=Complex.reflectInLine(DOMAIN[0].z[1],DOMAIN[0].z[2],z);
	    Complex w2=Complex.reflectInLine(DOMAIN[0].z[0],DOMAIN[0].z[2],w1);
	    return w2;
	}

	if(q==3) {
	    Complex w1=Complex.reflectInLine(DOMAIN[0].z[1],DOMAIN[0].z[2],z);
	    Complex w2=Complex.reflectInLine(DOMAIN[1].z[0],DOMAIN[1].z[1],w1);
	    return w2;
	}
	if(q==4) {
	    Complex w1=Complex.reflectInLine(DOMAIN[0].z[1],DOMAIN[0].z[2],z);
	    Complex w2=Complex.reflectInLine(DOMAIN[1].z[0],DOMAIN[1].z[2],w1);
	    return w2;
	}

	if(q==5) {
	    Complex w1=Complex.plus(z,HEX[0].z[0]);
	    Complex w2=Complex.minus(w1,HEX[1].z[4]);
	    return w2;
	}
	if(q==6) {
	    Complex w1=Complex.minus(z,HEX[0].z[0]);
	    Complex w2=Complex.plus(w1,HEX[1].z[4]);
	    return w2;
	}

	
	return z;
    }


    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTriangles(g);
      drawTriangles2(g);
      drawDomain(g);
      drawHex(g);
      if(M.C.HEX.mode==2) {
	  drawVertex(g);
	  drawFlower(g);
      }
   }

    public void drawFlower(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	Complex z=Complex.eis(SELECT[0],SELECT[1]);
	fillPoint(g,z,.05,new Color(50,0,50),32);
	int[] list=getFlower(SELECT[0],SELECT[1]);
	if(list==null) return;
	for(int i=0;i<list.length;++i) {
	     p=TRI[list[i]].toPath();
	     p=transform(p);
	     g.setColor(new Color(255,255,255,100));
	     g.fill(p);
	     g.setColor(new Color(255,200,0));
	     g.setStroke(new BasicStroke(2));
	     g.draw(p);
	}
        g.setStroke(new BasicStroke(1));
    }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(200,200,200));
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawTriangles(Graphics2D g) {
	Color C=Color.white;
	try{
  	    C=M.C.DISPLAY.M[0].C;
	}
	catch(Exception e) {return;}

	Path2D.Double p=new Path2D.Double();
	Color ED=M.C.DISPLAY.M[1].C;
	
	for(int i=0;i<COUNT;++i) {
            p=TRI[i].toPath();
	    p=transform(p);
	    g.setColor(C);
	    g.fill(p);
	    g.setColor(ED);
	    g.draw(p);
	}

	for(int i=0;i<COUNT;++i) {
	    PolygonWrapper P=TRI[i].conjugate();
            p=P.toPath();
	    p=transform(p);
	    g.setColor(C);
	    g.fill(p);
	    g.setColor(ED);
	    g.draw(p);
	}
    }


    public void drawTriangles2(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	Color[] C=new Color[3];
	try{
  	for(int i=0;i<3;++i) C[i]=M.C.DISPLAY.M[i+2].C;
	}
	catch(Exception e) {return;}
	Color ED=M.C.DISPLAY.M[1].C;
	int lim=11;
	if(M.C.HEX.mode==2) lim=1;
	for(int i=0;i<FACE.length;++i) {
	    for(int q=0;q<lim;++q) {
		if(FACE[i]>-1) {
       	           PolygonWrapper K=new PolygonWrapper(TRI[FACE[i]]);
		   K=DomainMap.doMap(q,DOMAIN,K);
                   p=K.toPath();
	           p=transform(p);
	           g.setColor(C[SOL[i]]);
	           g.fill(p);
	           g.setColor(ED);
	           g.draw(p);
		}
	    }
	}
    }
    
    public void drawDomain(Graphics2D g) {
	Color C=Color.black;
	Path2D.Double p=new Path2D.Double();

	g.setStroke(new BasicStroke(4));
	for(int i=0;i<2;++i) {
	     p=DOMAIN[i].toPath();
	    p=transform(p);
	    g.setColor(C);
	    g.draw(p);
       	}
	
	g.setStroke(new BasicStroke(2));
	
	C=Color.white;
	for(int i=0;i<2;++i) {
	     p=DOMAIN[i].toPath();
	    p=transform(p);
	    g.setColor(C);
	    g.draw(p);
       	}

	g.setStroke(new BasicStroke(1));
    }

    public void drawHex(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	Color C=new Color(0,0,0,100);
	for(int i=0;i<2;++i) {
	    p=HEX[i].toPath();
	    p=transform(p);
	    g.setColor(C);
	    g.fill(p);
	    g.setStroke(new BasicStroke(4));
	    g.setColor(Color.white);
	    g.draw(p);
	    g.setStroke(new BasicStroke(2));
	    g.setColor(Color.black);
	    g.draw(p);
	}
	g.setStroke(new BasicStroke(1));
    }
    

    public void drawVertex(Graphics2D g) {
	for(int i=0;i<VCOUNT;++i) {
	  Complex z=Complex.eis(VERTEX[i][0],VERTEX[i][1]);
 	  fillPoint(g,z,.1,Color.yellow,32);
	}
    }



    

    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    setDomain();
	}
	
	repaint();
    }

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    setDomain();
	}
	repaint();
    }

    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   



    public void doTest() {
	int[] x=recognizeSource();
	Complex z=Complex.eis(x[0],x[1]);
    }
    
    

}

