


function Cocycle() {
  this.Z=[];
  this.W=[];
  this.A=[]; 
  /**combinatorial structure*/ 
  /**Here are the indices of the control points**/
  this.r=[1,2,3,6,7,10,13,14,17,17,21];
  /**Here is the edge holonomy*/
  this.s=[3,5,4,5,4,4,5,4,5,4,4];
  /**here are the lead versus lag edges. 1==lead*/
  this.t=[1,1,1,0,0,1,1,0,0,1,0,0,1,1,0,0,1,1,0,0,1,0];  
  /**Here are the edge controls. Point k controls edge t[k]*/
  this.u=[-1,0,1,2,-1,-1,3,4,-1,-1,5,-1,-1,6,7,-1,-1,8,9,-1,-1,10]; 
  /**Here are the names of the edges after identification*/
  this.v=[0,1,2,2,1,3,4,4,3,5,5,0,6,7,7,6,8,9,9,8,10,10]; 
  /**Here are the partner points for keeping the closed condition.
     If we move point c we also move the point cc=w[c] oppositely*/
  this.w=[0,3,4,6,5,7,8,9,10,10,2];  
  /**These are the groupings of the vertices in the graph*/
  this.x=[0,1,2,3,2,1,4,5,4,1,6,1,0,7,8,7,0,9,10,9,0,11];
  /**Here are the pairings*/
  this.y=[11,4,3,2,1,8,7,6,5,10,9,0,15,14,13,12,19,18,17,16,21,20];
  /**end of combinatorial structure*/
  this.CHOICE=-1;
  /**The edge values for the minimial icosahedral tiling*/
  var S=[2,4,4,5,5,0,1,1,2,2,3];
  var V=basicRootList();
  for(var i=0;i<11;++i) this.Z[i]=V[S[i]];
  this.cocycleComplete=cocycleComplete;
  this.cocycleRender=cocycleRender;
  this.cocycleRenderSolid=cocycleRenderSolid;
  this.cocycleScale=cocycleScale;
  this.nearestPoint=nearestPoint;
  this.acceptPoint=acceptPoint;
  this.acceptPoint0=acceptPoint0;
  this.cocyclePoly=cocyclePoly;
  this.autoFit=autoFit;
  this.autoFitBounds=autoFitBounds;
  this.eisensteinBox=eisensteinBox;
  this.edgeMap=edgeMap;
}

function edgeMap(e,i,j) {  
  if(e<0) return 0;
  var z=eisenstein(i,j);
  var s=this.s[this.v[e]];
  s=(s+3)%6;
  var LAMBDA=basicRoot(s);
  var f=(this.y[e]+1)%22;
  if(this.t[e]==0) LAMBDA=cxInv(LAMBDA);
  var w1=this.A[e];
  var w2=this.A[f];
  z=cxTim(LAMBDA,z);
  var w3=cxTim(LAMBDA,w1);
  z=cxSub(z,w3);
  z=cxAdd(z,w2);
  var J=recognizeEis([z.x,z.y]);
  return J;
}

function basicRootList() {
  var V=[];
  for(var i=0;i<6;++i) V[i]=basicRoot(i);
  return V;
}

function cocycleScale(z) {
  for(var i=0;i<11;++i) {
    this.Z[i]=cxTim(z,this.Z[i]);
  }
  this.cocycleComplete();
}

function cocycleComplete() { 
  var V=basicRootList();
  for(var i=0;i<11;++i) this.W[i]=cxTim(V[this.s[i]],this.Z[i]);
  this.A[0]=new Complex(0,0);
  for(var i=0;i<22;++i) {
    if(this.t[i]==0) this.A[i+1]=cxAdd(this.A[i],this.W[this.v[i]]);
    if(this.t[i]==1) this.A[i+1]=cxAdd(this.A[i],this.Z[this.v[i]]);
  }
}


function cocycleRender(CAN) {
  this.cocycleComplete();
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
  for(var i=0;i<22;++i) {
    var p=new Path2D();
    p.moveTo(this.A[i].x,this.A[i].y);
    p.lineTo(this.A[i+1].x,this.A[i+1].y);   
    draw.lineWidth=4/TRANS[0];
    draw.strokeStyle=colors(this.v[i]);
    draw.stroke(p);
  }
  
  draw.lineWidth=1/TRANS[0];
  for(var i=0;i<22;++i) {
    var p=new Path2D();
    var alive=false;
    if(this.t[i-1]==1) alive=true;
    if(this.v[i-1]==10) alive=false;
    C=colors(this.v[i-1]);
    if(alive==false) C='#666';
    var r=.2;
    if(alive==false) r=0;
    p.arc(this.A[i].x,this.A[i].y,r,0,2*Math.PI,true); 
    draw.fillStyle=C;
    draw.fill(p); 
    if(i==this.CHOICE) {
      draw.lineWidth=2/TRANS[0];
      draw.strokeStyle='#fff';
      if(alive==true) draw.stroke(p); 
    }
  }
}


function cocycleRenderSolid(CAN) {
  this.cocycleComplete();
  var z=cxSub(this.A[22],this.A[0]);
  if(z.norm()>0.01) return;
  var P=this.cocyclePoly();
  if(P.isEmbedded()==false) P.COLOR='#f00';
  P.polyRender(CAN,true);
}


function cocyclePoly() {
  var Z=[];
  for(var i=0;i<22;++i) {
    Z[2*i+0]=this.A[i].x;
    Z[2*i+1]=this.A[i].y;
  }
  var P=new Poly(Z,22,'#ff0');
  return P;
}

 
 
function discretize(z) {
  var x0=z.x;
  var y0=z.y;
  var x1=x0-y0/Math.sqrt(3);
  var y1=2*y0/Math.sqrt(3);
  x1=Math.floor(x1+.5);
  y1=Math.floor(y1+.5);
  var x2=x1+y1/2;
  var y2=y1*Math.sqrt(3)/2;
  var z2=new Complex(x2,y2);
  return z2;
}



function nearestPoint(x) {
  var z=new Complex(x[0],x[1]);
  var index=-1;
  var min=.3;
  for(var i=0;i<22;++i) {
    var w=cxSub(z,this.A[i]);
    var test=w.norm();
    if((this.t[i-1]==1)&&(test<min)) {
      index=i;
      min=test;
      if(this.v[i-1]==10) index=-1;
    }
  }
  this.CHOICE=index;
}


function acceptPoint(z) {
  if(this.CHOICE<0) return;
  if(this.u[this.CHOICE]==10) return;
  var d0=this.CHOICE-1;
  var d1=this.CHOICE;
  var c=this.u[d1];
  var w=new Complex(z[0],z[1]);
  var u=cxSub(w,this.A[d1]);
  u=discretize(u);
  this.acceptPoint0(u,this.CHOICE);
}


function acceptPoint0(u,ch) {
  if(ch<0) return;
  var c=this.u[ch];
  this.Z[c]=cxAdd(this.Z[c],u);
  var cc=this.w[c];
  var uu=u.negate();
  if(c==8) uu=cxAdd(uu,cxTim(uu,basicRoot(1)));
  if(c!=0) this.Z[cc]=cxAdd(this.Z[cc],uu);
  this.cocycleComplete();
}



function eisensteinBox() {
  var t=this.autoFitBounds(); 
  var a1=squareToEis(t[0],t[1]);
  var a2=squareToEis(t[0],t[3]);
  var a3=squareToEis(t[2],t[1]);
  var a4=squareToEis(t[2],t[3]);
  var x0=Math.min(Math.min(a1[0],a2[0]),Math.min(a3[0],a4[0]));
  var y0=Math.min(Math.min(a1[1],a2[1]),Math.min(a3[1],a4[1]));
  var x1=Math.max(Math.max(a1[0],a2[0]),Math.max(a3[0],a4[0]));
  var y1=Math.max(Math.max(a1[1],a2[1]),Math.max(a3[1],a4[1]));
  x0=Math.floor(x0);
  y0=Math.floor(y0);
  x1=Math.floor(x1);
  y1=Math.floor(y1);
  return [x0,y0,x1,y1];
}


function autoFit() {
  var t=this.autoFitBounds();
  var min0=t[0];
  var min1=t[1];
  var max0=t[2];
  var max1=t[3];
  var mid0=(min0+max0)/2;
  var mid1=(min1+max1)/2;
  var d0=mid0-min0;
  var d1=mid1-min1;
  var d=Math.max(d0,d1);
  doFit([mid0,mid1,d],[650,350,320]);
}

function autoFitBounds() {
  var min0=+1000;
  var min1=+1000;
  var max0=-1000;
  var max1=-1000;
  for(var j=0;j<22;++j) {
    var x=this.A[j].x;
    var y=this.A[j].y;
    if(min0>x) min0=x;
    if(max0<x) max0=x;
    if(min1>y) min1=y;
    if(max1<y) max1=y;
  }
  return [min0,min1,max0,max1];
}


function colors(i) {
  var COL=['#000','#04f','#0d0','#d0d','#0cc',
           '#a00','#00b','#080','#808','#099',
           '#f30'];
 return COL[i];
}
