function reset() {
  MAIN=new Cocycle();
  MAIN.cocycleScale(SCALER.Z[SCALER.CHOICE]);
  MAIN.cocycleComplete();
  MAIN.autoFit();
  TRI.totalCompute();
  TRI.geomInitPoints();
  TRI.geomUpdate(50);
  var a=REMOTE.getChoice();
  if(a!=-1) MAIN.CHOICE=a; 
}

function setWindows(x,y) {
  if(WINDOW[0].buttonPress(x,y)==true) {
    WINDOW[0].on=1;
    WINDOW[1].on=0;
    MAIN.autoFit();
  }
  if(WINDOW[1].buttonPress(x,y)==true) {
    WINDOW[0].on=0;
    WINDOW[1].on=1; 
    doFit([0,0,1],[630,350,320]);
    try {
      TRI.geomInitPoints();
      TRI.geomUpdate(50);
      TRI.getSums();
    }
    catch(e) {}
  }
}

function doMouseDown(e) {
   DRAG=true;
   TIMER=(new Date()).getTime();
   var x=e.pageX;
   var y=e.pageY;
   if(x<300) DRAG=false;
   CLICK[0]=x;
   CLICK[1]=y;
   unTransform(x,y); 
   setWindows(x,y); 
   VTX.buttonToggle(x,y);  
   SIZE.arrowSliderPress(x,y);
   if(RAND.buttonPress(x,y)==true) {
      getRandom();
      TRI.getSums();
   }
   if(WINDOW[0].on==1) processSelector(x,y);
   if(WINDOW[1].on==1) processTri(x,y);
   repaint();
}


function processSelector(x,y) {
  GUIDE.buttonToggle(x,y); 
  if(FIT.buttonPress(x,y)==true) MAIN.autoFit();
  if(x>300) MAIN.nearestPoint(SOURCE);
  SCALER.setChoice(x,y);
  REMOTE.control(x,y);
  TRI.matchVertex(SOURCE);
  TRI.totalCompute();
}

function processTri(x,y) {
  TRI.geomUpdate(50); 
  if(SOLVE.buttonPress(x,y)==true) solve(TRI);
}


function doMouseUp(e) {
   DRAG=false;
   if(WINDOW[0].on==1) return;
   var x=e.pageX;
   var y=e.pageY;
   unTransform(x,y);
   var t=(new Date()).getTime()-TIMER;
   if((x>300)&&(t<300)) TRI.geomMatchCell(SOURCE);
   repaint();
}

function doMouseMove(e) {
   var x=e.pageX;
   var y=e.pageY; 
   if((MAIN.CHOICE==-1)&&(DRAG==true)) drag(e);
   if((WINDOW[1].on==1)&&(DRAG==true)) drag(e);
   CLICK[0]=x;
   CLICK[1]=y;
   unTransform(x,y);
   if((WINDOW[0].on==1)&&(x>300)&&(MAIN.CHOICE!=-1)&&(DRAG==true)) {
      MAIN.acceptPoint(SOURCE);
      TRI.getVertices();
      TRI.getNeighbors();
   }
   repaint();
}

/**This is for recentering*/

function drag(event) {
   var x0=CLICK[0];
   var y0=CLICK[1];
   var x=event.pageX;
   var y=event.pageY;
   unTransform(x,y); 
   TRANS[4]=TRANS[4]+(x-x0);
   TRANS[5]=TRANS[5]+(y-y0);
   CLICK[0]=x;
   CLICK[1]=y;
}
