

/**window opens with this routine*/
function init() { 
  var s = document.getElementById("picture"); 
  s.contentEditable=true;
  s.addEventListener('mousedown',doMouseDown,false);
  s.addEventListener('mouseup',doMouseUp,false);
  s.addEventListener('mousemove',doMouseMove,false); 
  s.addEventListener('keydown',doKeyDown,true);
  reset();
  startWorker();
  stopWorker();
  repaint();
}

var CANVAS = document.getElementById("picture"); 
var INFO=0;
var WRITER=new Writer();
var FIT=new Button([0,310,100,30],'#00f',"autofit");
var VTX=new Button([200,310,100,30],'#d00',"vertices");VTX.on=0;
var RAND=new Button([200,340,100,30],'#0a0',"random");
var SOLVE=new Button([100,440,100,30],'#04f',"solve");
var LINK=new Button([0,400,150,30],'#d00',"show links");LINK.on=0;
var GUIDE=new Button([100,310,100,30],'#f80',"guides");GUIDE.on=0;
var SIZE=new ArrowSlider([10,340,180,30],'#0a0','#060',30,100,"max");SIZE.val=44;
var WINDOW=[];
WINDOW[0]=new Button([0,670,150,30],'#0a0',"selector display");
WINDOW[1]=new Button([150,670,150,30],'#0a0',"triang display");
WINDOW[0].on=1;
WINDOW[1].on=0;
var TIMER=0;


var REMOTE=new Remote(); 
var TRI=new Triangulation();

var MAIN=new Cocycle();
var z=new Complex(1+2.0/2,2.0*Math.sqrt(3)/2);
MAIN.cocycleScale(z);
MAIN.autoFit();
var SCALER=new Scaler();
repaint();



var WORKER
var RUN=false;

function startWorker() {
  if(RUN==true) return;
  RUN=true;
  WORKER = new Worker("Counter.js");
  WORKER.onmessage = function(event) { 
    TRI.geomUpdateRepeat(50);
    repaint();
    WORKER.postMessage(0);
  }
}

function stopWorker() {
  RUN=false;
    WORKER.terminate();
}
