/**These are matrices over Z/3.  The entries are 0,1,2.*/

function Matrix(w,h) {
  this.W=w;
  this.H=h;
  this.m=[];
  for(var i=0;i<h;++i) {
    this.m[i]=[];
    for(var j=0;j<w;++j) {
      this.m[i][j]=0;
    }
  }
  this.matrixPrint=matrixPrint;
  this.addRow=addRow;
  this.leftNonzeroIndex=leftNonzeroIndex;
  this.nextRowIndex=nextRowIndex;
  this.clearColumn=clearColumn;
  this.rowSwap=rowSwap;
  this.leftToOne=leftToOne;
  this.rowReverse=rowReverse;
  this.rowReduce=rowReduce;
  this.variableDependency=variableDependency;
  this.evaluateVector=evaluateVector;
}




function matrixPrint() {
  console.log("matrix");
  console.log(this.W);
  for(var i=0;i<this.H;++i) console.log(arrayToString(this.m[i]));
}

function rowReduce() {
  this.rowReverse();
  var q=0;
  for(var i=0;i<this.H;++i) {
    q=i;
    if(i<this.H-1) {
       q=this.nextRowIndex(i);
       if(q>i) this.rowSwap(i,q);
    }
    this.clearColumn(i); 
  } 
  this.leftToOne(); 
  this.rowReverse();
}

function rowReverse() {
  for(var i=0;i<this.H;++i) this.m[i]=reverse(this.m[i]);
}

function leftToOne(u) {
  for(var i=0;i<this.H;++i) leftToOne0(this,i);
}

function leftToOne0(M,u) {
  var k=M.leftNonzeroIndex(u);
  if(k==-1) return;
  var a=M.m[u][k];
  for(var i=0;i<M.W;++i) {
    M.m[u][i]=(M.m[u][i]*a)%3;
  }
}

function addRow(u,v,a) {
  for(var i=0;i<this.W;++i) {
    var b=a*this.m[u][i];
    var c=this.m[v][i];
    this.m[v][i]=(b+c)%3;
  }
}

function rowSwap(u,v) {
  for(var i=0;i<this.W;++i) {
      var A=this.m[u][i];
      this.m[u][i]=this.m[v][i];
      this.m[v][i]=A;
  }
}

function leftNonzeroIndex(u) {
  for(var i=0;i<this.W;++i) {
    if(this.m[u][i]!=0) return i;
  }
  return -1;
}

function nextRowIndex(k) {
  var index=-1;
  var min=this.W+1;
  for(var i=k;i<this.H;++i) {
    var j=this.leftNonzeroIndex(i);
    if((j>=k)&&(j<min)) {
      index=i;
      min=j;
    }
  }
  return index;
}


function clearColumn(u) {
  var k=this.leftNonzeroIndex(u);
  if(k==-1) return;
  var a=this.m[u][k];
  for(var v=0;v<this.H;++v) {  
    if(v!=u) {
	var b=this.m[v][k];
	var c=(2*a*b)%3;
	this.addRow(u,v,c);
    }
  }
}


function variableDependency() {
  var D=[];
  var I=[];
  var CD=0;
  var CI=0;
  var count=0;
  for(var i=0;i<this.W;++i) {
    var z=columnSum(this,i);
    if(z[0]>1) {
      I[CI]=i;
      ++CI;
    } 
    if(z[0]==1) {
      D[CD]=i;
      ++CD;
     }
  }
  D=reverse(D);
  return [I,D];
}




function columnSum(M,j) {
  var tot=0;
  var index=0;
  for(var i=0;i<M.H;++i) {
    tot=tot+M.m[i][j];
    if(M.m[i][j]!=0) index=i;
  }
  return [tot,index];
}



function evaluateVector(F) {
  var E=[];
  for(var i=0;i<this.H;++i) {
    E[i]=vectorDot(this.m[i],F);
    E[i]=(E[i]+3000)%3;
  }
  return E;
}



function vectorDot(A,B) {
  var tot=0;
  for(var i=0;i<A.length;++i) {
    tot=tot+A[i]*B[i];
  }
  return tot;
}
