
/**Here is a polygon object*/

function Poly(Z,n,COLOR) {
   this.Z=Z;
   this.n=n;
   this.COLOR=COLOR;
   this.inside=0;
   this.polyInside=polyInside;
   this.polyInsideRobust=polyInsideRobust;
   this.polyOnVertex=polyOnVertex;
   this.polyOnEdge=polyOnEdge;
   this.polyRender=polyRender;
   this.polyRender2=polyRender2;
   this.polyCopy=polyCopy;
   this.toPath=toPath;
   this.polyRenderUnscaled=polyRenderUnscaled;
   this.translate=translate;
   this.isEmbedded=isEmbedded;
   this.whichEdgeCross=whichEdgeCross;
}

/**Draws the polygon. F determines whether
   you draw the whole thing or just the outline*/

function polyRender(CANVAS,F) {
    var draw = CANVAS.getContext('2d');
    var p=this.toPath();
    draw.fillStyle=this.COLOR;
    draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
    if(F==true) draw.fill(p);
    draw.strokeStyle='#fff'; 
    if(F==false) draw.strokeStyle='#bdf';
    draw.lineWidth=1/TRANS[0];
    draw.stroke(p);
}

function polyRender2(CANVAS,INSIDE,OUTLINE,THICKNESS) {
    var draw = CANVAS.getContext('2d');
    var p=this.toPath();
    draw.fillStyle=INSIDE;
    draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
    draw.fill(p);
    draw.strokeStyle=OUTLINE;
    draw.lineWidth=THICKNESS/TRANS[0];
    draw.stroke(p);
}



function toPath() {
    var p=new Path2D();
    for(var i=0;i<this.n;++i) {
       if(i==0) p.moveTo(this.Z[0],this.Z[1]);
       if(i!=0) p.lineTo(this.Z[2*i],this.Z[2*i+1]);
    }
    p.closePath();
    return p;
}


/**Draws the polygon in absolute coordinates.
   Used with the remote control*/

function polyRenderUnscaled(CANVAS) {
    var draw = CANVAS.getContext('2d');
    var p=new Path2D();
    draw.fillStyle=this.COLOR;
    for(i1=0;i1<this.n;++i1) {
       if(i1==0) p.moveTo(this.Z[0],this.Z[1]);
       if(i1!=0) p.lineTo(this.Z[2*i1],this.Z[2*i1+1]);
    }
    p.closePath();
    draw.setTransform(1,0,0,1,0,0);
    draw.fill(p);
    draw.strokeStyle='#fff'; 
    draw.lineWidth=1;
    draw.stroke(p);
}


/**This determines whether the polygon
   contains the point (x,y).  This routine
   only works with CONVEX polygons.*/

function polyInside(x,y) {
   var total=0;
   this.inside=1;
   var MEM=[0,0,0,0];
   
   for(q=0;q<this.n;++q) {
       var j=(q+1)%this.n;;
       var A1=this.Z[2*q+0]-x;
       var A2=this.Z[2*q+1]-y;
       var B1=this.Z[2*j+0]-x;
       var B2=this.Z[2*j+1]-y;
       MEM[q]=A1*B2-A2*B1; 
    }
   if(MEM[0]*MEM[1]<0) return false;
   if(MEM[0]*MEM[2]<0) return false;
   if(MEM[0]*MEM[3]<0) return false;
   return true;
}


/**This works for non-convex polygons as well.*/

function polyInsideRobust(x,y) {
   var total=0;
   for(i=0;i<this.n;++i) {
     var j=i+1;
     if(j==this.n) j=0;
     var A1=this.Z[2*i+0]-x;
     var A2=this.Z[2*i+1]-y;
     var B1=this.Z[2*j+0]-x;
     var B2=this.Z[2*j+1]-y;
     var A3=Math.sqrt(A1*A1+A2*A2);
     var B3=Math.sqrt(B1*B1+B2*B2);
     A1=A1/A3;
     A2=A2/A3;
     B1=B1/B3;
     B2=B2/B3;
     var C=A1*B1+A2*B2; //dot
     var S=A1*B2-A2*B1; //cross
     var angle = Math.atan2(S,C);
     total=total+angle;
   }
   if(total*total>.0001) return true;
   return false;
}


function polyOnVertex(x,y) {
   for(i=0;i<this.n;++i) {
     var A1=this.Z[2*i+0]-x;
     var A2=this.Z[2*i+1]-y;
     var z=new Complex(A1,A2);
     if(z.norm()<.00001) return [true,i];
   }
   return false;
}

function polyOnEdge(x,y) {
   for(var i=0;i<this.n;++i) {
     var j=(i+1)%this.n;
     var A1=this.Z[2*i+0];
     var A2=this.Z[2*i+1]; 
     var B1=this.Z[2*j+0];
     var B2=this.Z[2*j+1];
     var w0=new Complex(x,y);
     var w1=new Complex(A1,A2);
     var w2=new Complex(B1,B2);
     var d01=cxDist(w0,w1);
     var d02=cxDist(w0,w2);
     var d12=cxDist(w1,w2); 
     if(d01+d02<d12+.0000001) return [true,i,d01/d12];
   }
   return false;
}


function whichEdgeCross(a0,b0,a1,b1) {
  var w0=eisenstein(a0,b0);
  var w1=eisenstein(a1,b1);
     for(var i0=0;i0<this.n;++i0) { 
        var i1=(i0+1)%this.n;
        var z0=new Complex(this.Z[2*i0+0],this.Z[2*i0+1]);
        var z1=new Complex(this.Z[2*i1+0],this.Z[2*i1+1]); 
        if(disjoint(z0,z1,w0,w1)==false) return i0;
     }
     return -1;
}

function isEmbedded() {
  for(var i0=0;i0<this.n;++i0) {
    for(var j0=0;j0<this.n;++j0) {
      var i1=(i0+1)%this.n;
      var j1=(j0+1)%this.n;
      var test=true;
      if(i0==j0) test=false;
      if(i0==j1) test=false;
      if(i1==j0) test=false;
      if(i1==j1) test=false;   
      if(test==true) {
        var z0=new Complex(this.Z[2*i0+0],this.Z[2*i0+1]);
        var z1=new Complex(this.Z[2*i1+0],this.Z[2*i1+1]);
        var w0=new Complex(this.Z[2*j0+0],this.Z[2*j0+1]);
        var w1=new Complex(this.Z[2*j1+0],this.Z[2*j1+1]);
        if(disjoint(z0,z1,w0,w1)==false) return false;
      }
    }
  }

  for(var i0=0;i0<this.n;++i0) {
    var i1=(i0+1)%this.n;
    var i2=(i0+2)%this.n;
    var z0=new Complex(this.Z[2*i0+0],this.Z[2*i0+1]);
    var z1=new Complex(this.Z[2*i1+0],this.Z[2*i1+1]);
    var z2=new Complex(this.Z[2*i2+0],this.Z[2*i2+1]);
    if(isFolded(z0,z1,z2)==true) return false;
  }
  return true;
}


function toPoly(X) {
  var n=X.length;
  var Y=[];
  for(var i=0;i<n;++i) {
    Y[2*i+0]=X[i][0];
    Y[2*i+1]=X[i][1];
  }
  var P=new Poly(Y,n,'#fff');
  return P;
}

function translate(x,y) {
  for(var i=0;i<this.n;++i) {
    this.Z[2*i+0]=this.Z[2*i+0]+x;
    this.Z[2*i+1]=this.Z[2*i+1]+y;
  }
}

function polyCopy() {
  var Y=[];
  for(var i=0;i<this.n;++i) {
    Y[2*i+0]=this.Z[2*i+0];
    Y[2*i+1]=this.Z[2*i+1];
  }
  var P=new Poly(Y,this.n,this.COLOR);
  return P;
}
