
function repaint() { 
   var draw = CANVAS.getContext('2d'); 
   draw.fillStyle='#fff';
   if(WINDOW[0].on==1) drawSelector();
   if(WINDOW[1].on==1) drawTriangulation();
   drawControls();
   drawFeatures();
   drawCrosshairs();  
   drawFrame(); 
}


function drawFeatures() { 
   var draw = CANVAS.getContext('2d'); 
   draw.font = '14pt Helvetica'; 
   draw.fillStyle='#fff';
   var S=TRI.CELLCOUNT.toString();
   S=S+" triangles";
   if(TRI.BAD.length!=0) S="no triangulation";
   draw.fillText(S,5,400);
}

function drawFrame() {
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(1,0,0,1,0,0);
  draw.strokeStyle='#fff';
  draw.lineWidth=3;
  draw.strokeRect(0,0,1000,700);
  draw.strokeRect(0,0,300,700);
  draw.strokeRect(300,0,700,700);
}


function drawControls() {
  var draw = CANVAS.getContext('2d');  
  draw.setTransform(1,0,0,1,0,0);
  draw.clearRect(0,0,300,700);
  draw.fillStyle='#68a';
  draw.fillRect(0,0,300,700);
  if(WINDOW[0].on==1) drawControlsSelector();
  if(WINDOW[1].on==1) drawControlsDisplay(); 
  WINDOW[0].buttonRender(CANVAS);
  WINDOW[1].buttonRender(CANVAS);
  VTX.buttonRender(CANVAS);
  RAND.buttonRender(CANVAS); 
  SIZE.arrowSliderRender(CANVAS);
}


function drawControlsSelector() {
  FIT.buttonRender(CANVAS);
  GUIDE.buttonRender(CANVAS);
  SCALER.scalerRender(CANVAS);
  REMOTE.remoteRender(CANVAS);
}


function drawControlsDisplay() {
  SOLVE.buttonRender(CANVAS);
}

function drawCrosshairs() { 
    var draw = CANVAS.getContext('2d'); 
    draw.setTransform(1,0,0,1,0,0);
    var p=new Path2D();
    draw.lineWidth=2;
    p.moveTo(CLICK[0]-4,CLICK[1]);
    p.lineTo(CLICK[0]+4,CLICK[1]);
    p.moveTo(CLICK[0],CLICK[1]-4);
    p.lineTo(CLICK[0],CLICK[1]+4);
    p.closePath();
    draw.strokeStyle='#fff';
    draw.stroke(p);
}


function drawSelector() {
  var draw = CANVAS.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.clearRect(300,0,700,700);
   draw.fillStyle='#fff';
   draw.fillRect(300,0,700,700);
   if(TRI.BAD.length>0) draw.fillStyle='#400';
   MAIN.cocycleRenderSolid(CANVAS);
   drawGrid();
   MAIN.cocycleRender(CANVAS); 
   if(VTX.on==1) TRI.vertexRender(CANVAS);
}

function drawTriangulation() { 
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(1,0,0,1,0,0);
  draw.clearRect(300,0,700,700);
  if(TRI.BAD.length>0) {
    draw.font = '14pt Helvetica'; 
    draw.fillStyle='#fff';
    draw.fillText("This is not a triangulation. Try again.",305,20);
    return;
  }
  TRI.geomRender(CANVAS);
}


function drawGrid() {
    var draw = CANVAS.getContext('2d');
    draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
    draw.strokeStyle='#666';
    draw.lineWidth=1/TRANS[0];
    var s=Math.sqrt(3)/2;
    for(var i=-100;i<100;++i) {
      for(var j=0;j<3;++j) {
        var z0=new Complex(-100,s*i);
        var z1=new Complex(+100,s*i);
	var w=cis(j*Math.PI/3);
        z0=cxTim(w,z0);
        z1=cxTim(w,z1);
        var p=new Path2D(); 
	p.moveTo(z0.x,z0.y);
	p.lineTo(z1.x,z1.y);
        draw.stroke(p);
      }
    }
}


/**This draws a thick rectangle with a 3px white border*/
function thickBox(x0,y0,w0,h0,COL) {
   var draw = CANVAS.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.fillStyle = COL;
   draw.fillRect(x0,y0,w0,h0);
   draw.strokeStyle = '#fff';
   draw.lineWidth=2;
   draw.strokeRect(x0,y0,w0,h0);
   draw.lineWidth=1;
}

     
/**This sets the scale to that the bounding box is mapped to the
   given square*/

function doFit(X,Y) {
   var s=Y[2]/X[2];
   TRANS[0]=s;
    TRANS[1]=0;
    TRANS[2]=0;
    TRANS[3]=-s;
    TRANS[4]=Y[0]-s*X[0];
    TRANS[5]=Y[1]+s*X[1];
}


function drawDisk(CAN,x,y,r,COL) {
   var Z=[]
   for(ii=0;ii<64;++ii) {
     var t=2*Math.PI*ii/64;
     Z[2*ii+0]=x+r*Math.cos(t);
     Z[2*ii+1]=y+r*Math.sin(t);
   } 
   var P=new Poly(Z,64,COL);
   P.polyRender(CAN,true);
}

function drawDiskUnscaled(CAN,x,y,r,COL) {
   var Z=[]
   for(ii=0;ii<64;++ii) {
     var t=2*Math.PI*ii/64;
     Z[2*ii+0]=x+r*Math.cos(t);
     Z[2*ii+1]=y+r*Math.sin(t);
   } 
   var P=new Poly(Z,64,COL);
   P.polyRenderUnscaled(CAN,true);
}
