/**This has routines which deal with the cycle structure of the 
   triangulation.  The first routine is the main one.*/

function cycleFix() {
  for(var i=0;i<this.COUNT;++i) cycleFix0(this,i);
}

function cycleFix0(T,i) {
  var H=cycle(T,i);
  T.EDGE[i]=H;
}

function cycle(T,i) {
  var G=[];
  var E=T.EDGE[i];

  for(var j=0;j<E.length;++j) {
    var k=E[j];
    var temp=triangles(T,i,k);
    G[2*j+0]=[k,temp[0]];
    G[2*j+1]=[k,temp[1]];
  }

  var H=G[0];
  for(var i=0;i<5;++i) {
    H=amalgamate(H,G);
  }
  return H;
}

function triangles(T,i,j) {
  var A=T.EDGE[i];
  var B=T.EDGE[j];
  var C=intersection(A,B);
  return C;
}

function edge(T,i,j) {
  return onList(i,T.EDGE[j]);
}





