/**This routines which make sure that the
   cyclic order of the link of each vertex
   is counterclockwise.  This isn't needed
   but it is nice to have.  These routines would
   be added to the Triangulation class.  The first
   routine, resolve sense, is the main one.*/


function resolveSense() {
   var L=this.orderBFS();
   for(var i=0;i<L.length;++i) {
     for(var j=i+1;j<L.length;++j) {
         this.resolveSense0(L[i],L[j]);
     }
   }
}

function resolveSense0(a,b) {
  var A=this.EDGE[a];
  var B=this.EDGE[b];
  var test=this.senseMatch(a,b);
  if(test==-1) this.EDGE[b]=reverse(B);
}


function senseMatch(a,b) {
  var A=this.EDGE[a];
  var B=this.EDGE[b];
  var C=intersection(A,B);
  if(C.length<2) return 0;
  var i1=onListNum(C[0],A);
  var i2=onListNum(C[1],A);
  var i3=(i2+A.length-i1)%A.length;
  var j1=onListNum(C[0],B);
  var j2=onListNum(C[1],B);
  var j3=(j2+B.length-j1)%B.length;
  if(i3==1) return 0;
  if(j3==1) return 0;
  if(i3==A.length-1) return 0;
  if(j3==B.length-1) return 0;
  if((i3==2)&&(j3==2)) return -1;
  if((i3!=2)&&(j3!=2)) return -1;
  return 1;
}


function orderBFS() {
  var L=[0];
  var test=false;
  while(test==false) {
    var n=L.length;
    L=this.enlargeBFS(L);
    if(L.length==n) test=true;
  }
  return L;
}


function enlargeBFS(L) {
  var M=[];
  for(var i=0;i<L.length;++i) M[i]=L[i];
  for(var i=0;i<L.length;++i) {
    M=union(M,this.EDGE[L[i]]);
  }
  return M;
}





