function geomMatchCell(z) { 
  var Z=this.POINT;
  for(var i=0;i<this.CELLCOUNT;++i) {
     var c=this.CELL[i]; 
    var P=new Poly([20*Z[c[1]].x,20*Z[c[1]].y,Z[c[1]].x,Z[c[1]].y,
                    Z[c[2]].x,Z[c[2]].y,20*Z[c[2]].x,20*Z[c[2]].y],4,'#fff');
    if(i>4) {
     P=new Poly([Z[c[0]].x,Z[c[0]].y,
                     Z[c[1]].x,Z[c[1]].y,
                     Z[c[2]].x,Z[c[2]].y],3,'#002');
    }
       if(P.polyInside(z[0],z[1])==true) {
     if(i>4) {
            this.CELL[i][3]=-this.CELL[i][3];
            this.CELLCHOICE=i;
     }
     }
  }  
 
  var c=this.CELL[this.CELLCHOICE];
  console.log("cell chosen: "+this.CELLCHOICE);
  for(var i=0;i<3;++i) {
    var A=getBinary(this,c[i]);
    this.SUM[c[i]]=listSum(A);
  }
}
 
 
/**************rendering*********************/
 
function geomRender(CAN) {  
  var draw = CAN.getContext('2d'); 
  var Z=this.POINT;
  var n=this.POINT.length; 
 
  for(var i=0;i<this.CELLCOUNT;++i) {
    var c=this.CELL[i];
     var P=new Poly([20*Z[c[1]].x,20*Z[c[1]].y,Z[c[1]].x,Z[c[1]].y,
                    Z[c[2]].x,Z[c[2]].y,20*Z[c[2]].x,20*Z[c[2]].y],4,'#fff');
    if(i>4) {
       P=new Poly([Z[c[0]].x,Z[c[0]].y,
                     Z[c[1]].x,Z[c[1]].y,
                     Z[c[2]].x,Z[c[2]].y],3,'#000');
    }
    var col=['#ff0','#fff','#000'];
    var index=(c[3]+3)%3;
    var cc=col[index];
    if(i<5) cc='#000';
    if(i==0) cc='#fff';
    P.polyRender2(CAN,cc,'#888',2);
  }
 
  if(VTX.on==1) geomRenderVertex(this,CAN,Z);
}
 
 
function geomRenderVertex(T,CAN,Z) { 
  var draw = CAN.getContext('2d'); 
  draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
  var n=T.COUNT;
  for(var i=1;i<n;++i) { 
    var p=new Path2D();
    var C=['#fff','#00a','#a00'];
    var t=geomInjectivity(T,i);
    t=t/4;
    if(t>.05) t=.05;
 
    p.arc(Z[i].x,Z[i].y,t,0,2*Math.PI);
    var bin=(6+T.SUM[i])%3;
 
    draw.fillStyle=C[bin];
    draw.fill(p);  
    draw.strokeStyle='#fff'; 
    if(bin==0) draw.strokeStyle='#000';
    draw.lineWidth=2/TRANS[0];
    draw.stroke(p); 
  }
}
 
function geomInjectivity(T,i) {
  var min=1;
  var E=T.EDGE[i];
  for(var j=0;j<E.length;++j) {
    var k=E[j];
    var test=cxDist(T.POINT[i],T.POINT[k]);
    if(test<min) min=test;
  }
  return min;
}
/***************end rendering routines******************/
 
 
 
 
/******evolution to harmonic position*******/
 
 
function geomInitPoints() {
  this.POINT=[];
  for(var i=0;i<this.COUNT;++i) {
    this.POINT[i]=new Complex(0,0);
  }
  this.POINT[0]=new Complex(100,100);
  var  H=this.EDGE[0];
 
  for(var i=0;i<5;++i) { 
    var k=H[i];
    var c=Math.cos(2*(i+2)*Math.PI/5);
    var s=Math.sin(2*(i+2)*Math.PI/5);
    this.POINT[k]=new Complex(c,s);
  }
}
 
 
function geomUpdate0(T) {
  var n=T.COUNT;
  var test=false;
  while(test==false) {
    var i=Math.floor(n*Math.random());
    var test2=onList(i,T.EDGE[0]);
    if((test2==false)&&(i!=0)) test=true;
  }
 
  var z=new Complex(0,0);
  var E=T.EDGE[i];
  for(var j=0;j<E.length;++j) {
    var k=E[j];
    z=cxAdd(z,T.POINT[k]);
  }
  z.x=z.x/E.length;
  z.y=z.y/E.length;
  T.POINT[i]=new Complex(z.x,z.y);
}
   
 
function geomUpdate(time) {
  var d=new Date();
  var t=d.getTime();
  var test=false; 
  while(test==false) {
    var d1=new Date();
    var t1=d1.getTime()-t;
    if(t1>time) test=true;
    geomUpdate0(this);
  }
}



