
/***These routines have to do with getting the vertex list.
    Here is the main routine*/

function getVertices() {
  this.RAW=[]; 
  var count=0;
  var t=MAIN.eisensteinBox();
  for(var i=t[0]-2;i<t[2]+2;++i) {
    for(var j=t[1]-2;j<t[3]+2;++j) {
      var z=eisenstein(i,j);  
      test=detectInteriorStrict(i,j);
      if(test!=false) {
	this.RAW[count]=[2,i,j];
        ++count;
      }
      test=detectEdgeStrict(i,j);
      if(test!=false) {
	this.RAW[count]=[1,i,j,test[1],test[2],test[3]];
        ++count;
      }

      test=detectVertex(i,j);
      if(test!=false) {
     	this.RAW[count]=[0,i,j,MAIN.x[test[1]]];
        ++count;
      }
    }
  }
  condense(this);
}


function detectInterior(i,j) {
  var z=eisenstein(i,j);
  var P=MAIN.cocyclePoly();
  var test=P.polyInsideRobust(z.x,z.y);
  return test;
}

function detectVertex(i,j) {
  var z=eisenstein(i,j);
  var P=MAIN.cocyclePoly();
  var test=P.polyOnVertex(z.x,z.y);
  return test;
}

function detectEdge(i,j) {
  var z=eisenstein(i,j);
  var P=MAIN.cocyclePoly();
  var test=P.polyOnEdge(z.x,z.y);
  return test;
}

function detectEdgeStrict(i,j) {
  var test=detectVertex(i,j);
  if(test!=false) return false;
  var f=detectEdge(i,j);
  if(f==false) return false; 
  var d=f[2];
  var e=MAIN.t[f[1]];
  if(e==0) d=1-d;
  return [true,MAIN.v[f[1]],e,d];
}

function detectInteriorStrict(i,j) {
  var test=detectVertex(i,j);
  if(test!=false) return false;
  test=detectEdge(i,j);
  if(test!=false) return false;
  return detectInterior(i,j);
}

function condense(T) {
  T.LIST=[];
  var n=T.RAW.length;
  var count=0;

  for(var i=0;i<12;++i) T.LIST[i]=condenseVertex(T,i);
  count=12;

  for(var i=0;i<n;++i) {
    if(T.RAW[i][0]==2) {
      T.LIST[count]=[2,-1,[T.RAW[i][1],T.RAW[i][2]]];
      ++count;
    }
  }

  for(var i=0;i<n;++i) {
    for(var j=i+1;j<n;++j) {
      var test=condenseEdge(T.RAW[i],T.RAW[j]); 
      if(test!=false) {
        T.LIST[count]=test;
	++count;
      }
    }
  }
  T.COUNT=count;
}

function condenseVertex(T,k) {
  var n=T.RAW.length;
  var L=[0,k];
  var count=2;
  for(var j=0;j<n;++j) {
    var X=T.RAW[j];
    if((X[0]==0)&&(X[3]==k)) {
      L[count]=[X[1],X[2]];
      ++count;
    }
  }
  return L;
}

function condenseEdge(A,B) {
  if(A[0]!=1) return false;
  if(B[0]!=1) return false;
  if(A[3]!=B[3]) return false;
  if(A[4]==B[4]) return false;
  if(Math.abs(A[5]-B[5])>.00001) return false;
  if(A[4]==1) return [1,A[3],[A[1],A[2]],[B[1],B[2]]];
  return [1,A[3],[B[1],B[2]],[A[1],A[2]]];
}


