
function determineInfo(x,y) {
  if(SIZE.arrowSliderDetect(x,y)==true) INFO=1;
  if((x>300)&&(y>30)) INFO=2;
  if(x<300)INFO=3;
  if(y>730) INFO=4;
  if(RAND.buttonPress(x,y)==true) INFO=5;
  if(SOLVE.buttonPress(x,y)==true) INFO=6;
}

function drawInfo() {
  if(INFO==1) drawTriInfo();
  if(INFO==2) drawBoardInfo();
  if(INFO==3) drawInfoInfo();
  if(INFO==4) drawStripInfo();
  if(INFO==5) drawGameInfo();
  if(INFO==6) drawSolveInfo();
}


function drawTriInfo() {
  var S="The program creates a fairly random triangulation of the sphere in which all vertices have degree 5 or 6.  (There will be exactly 12 vertices of degree 5.)  These arrow keys let you roughly specify the number of triangles.";
  setTextBox([0,500,300,230],CANVAS,S,'#088',1);
}


function drawBoardInfo() {
  var S="This is the playing board. Click on the triangles to switch their color.  Use the letter and number keys to zoom in and out.  Use the spacebar to reset the scale of the window.  Drag the mouse over the window to recenter it.";
  setTextBox([0,500,300,230],CANVAS,S,'#004',2);
}


function drawInfoInfo() {
  var S="The left half of this program gives information about the program. The right half is the playing board.  Move the cursor over other parts of the program and you can read here about what they do.";
  setTextBox([0,500,300,230],CANVAS,S,'#606',3);
}


function drawStripInfo() {
  var S="This bottom strip is here to remind you of the keyboard commands you can use to rescale the window.  Note that you first need to click on the window to activate the key commands.  Put another way, don't make trying the key commands the first thing you do.";
  setTextBox([0,500,300,230],CANVAS,S,'#456',4);
}


function drawGameInfo() {
  var S="When you press this button, the program chooses another random triangulation and starts a new game.  The more triangles, the harder the game.  One bug in the program is that it sometimes takes a long time to find a random triangulation with under 30 triangles.";
  setTextBox([0,500,300,230],CANVAS,S,'#048',5);
}

function drawSolveInfo() {
  var S="Press this if you want to see a solution to the present game.  The solver first eliminates as many free variables as possible using row reduction, then does greedy random evolution.  This works well for triangulations having less than 100 triangles.";
  setTextBox([0,500,300,230],CANVAS,S,'#080',6);
}


