
function repaint() { 
   var draw = CANVAS.getContext('2d'); 
   draw.fillStyle='#fff';
   drawTriangulation();
   drawControls();
   drawTitle();
   drawInfo();
   drawFeatures();
   drawCrosshairs();  
   drawFrame(); 
}

function drawTitle() { 
  var draw = CANVAS.getContext('2d'); 
  draw.font = '28pt Calibri'; 
  draw.fillStyle='#ff0';
  draw.fillText("The 4 Color Game",10,35);
  draw.fillStyle='#0ff'; 
  draw.font = '15pt Calibri'; 
  draw.fillText("by Rich Schwartz",70,65);

  var S="The purpose of this game is to color the triangles white/black so that, around each vertex, the number of white triangles minus the number of black triangles is divisible by 3.  The vertex is colored gold when this happens, and otherwise magenta/blue according to the nature of the mismatch.  Click on the triangles to switch their colors.  (The outer triangles cannot be changed.)  You win when all vertices are gold. A winning white-black face coloring is equivalent to a proper 4-coloring of the vertices.";
  setTextBox([0,75,300,425],CANVAS,S,'#a0a',0);
}

function drawFeatures() { 
   var draw = CANVAS.getContext('2d'); 
   draw.font = '13pt Helvetica'; 
   draw.fillStyle='#ff0';
   var S=TRI.CELLCOUNT.toString();
   S="("+S+" triangles)";
   draw.fillText(S,702,22);
   draw.fillStyle='#fff'; 
   var a=SIZE.val;
   var b=a-10;
   var Sa=a.toString();
   var Sb=b.toString();
   var SS=Sb+" to "+Sa+" triangles";
   draw.fillText(SS,SIZE.Z[0]+5,SIZE.Z[1]+SIZE.Z[3]-7);
   a=HINT.val.toString(); 
   draw.fillStyle='#ff0';
   draw.fillText("mouse drag the window to recenter",10,752);
   draw.fillText("press letter keys to zoom in",310,752);
   draw.fillText("press number keys to zoom out",545,752);
   draw.fillText("spacebar resets zoom",820,752);
}

function drawFrame() {
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(1,0,0,1,0,0);
  draw.strokeStyle='#fff';
  draw.lineWidth=3;
  draw.strokeRect(300,0,700,30);
  draw.strokeRect(0,730,1000,30);
  draw.strokeRect(300,30,700,700);
  draw.strokeRect(0,0,300,730);
}


function drawControls() {
  var draw = CANVAS.getContext('2d');  
  draw.setTransform(1,0,0,1,0,0);
  draw.clearRect(0,0,300,760);
  draw.clearRect(300,0,700,30);
  draw.clearRect(0,730,1000,30);
  draw.fillStyle='#044';
  draw.fillRect(300,0,700,30);
  draw.fillStyle='#505';
  draw.fillRect(0,0,300,760);
  draw.fillStyle='#456';
  draw.fillRect(0,730,1000,30);
  drawControlsDisplay(); 
  RAND.buttonRender(CANVAS); 
  SIZE.arrowSliderRender(CANVAS);
   
}

function drawControlsDisplay() {
  SOLVE.buttonRender(CANVAS);
}

function drawCrosshairs() { 
    var draw = CANVAS.getContext('2d'); 
    draw.setTransform(1,0,0,1,0,0);
    var p=new Path2D();
    draw.lineWidth=2;
    p.moveTo(CLICK[0]-4,CLICK[1]);
    p.lineTo(CLICK[0]+4,CLICK[1]);
    p.moveTo(CLICK[0],CLICK[1]-4);
    p.lineTo(CLICK[0],CLICK[1]+4);
    p.closePath();
    draw.strokeStyle='#fff';
    draw.stroke(p);
}



function drawTriangulation() { 
  var draw = CANVAS.getContext('2d'); 
  draw.setTransform(1,0,0,1,0,0);
  draw.clearRect(300,30,700,700);
  draw.fillStyle='#000';
  draw.fillRect(300,30,700,700);
  if(TRI.BAD.length>0) {
    draw.font = '14pt Helvetica'; 
    draw.fillStyle='#fff';
    draw.fillText("This is not a triangulation. Try again.",305,20);
    return;
  }
  TRI.geomRender(CANVAS);
}


function drawGrid() {
    var draw = CANVAS.getContext('2d');
    draw.setTransform(TRANS[0],TRANS[1],TRANS[2],TRANS[3],TRANS[4],TRANS[5]);
    draw.strokeStyle='#666';
    draw.lineWidth=1/TRANS[0];
    var s=Math.sqrt(3)/2;
    for(var i=-100;i<100;++i) {
      for(var j=0;j<3;++j) {
        var z0=new Complex(-100,s*i);
        var z1=new Complex(+100,s*i);
	var w=cis(j*Math.PI/3);
        z0=cxTim(w,z0);
        z1=cxTim(w,z1);
        var p=new Path2D(); 
	p.moveTo(z0.x,z0.y);
	p.lineTo(z1.x,z1.y);
        draw.stroke(p);
      }
    }
}


/**This draws a thick rectangle with a 3px white border*/
function thickBox(x0,y0,w0,h0,COL) {
   var draw = CANVAS.getContext('2d'); 
   draw.setTransform(1,0,0,1,0,0);
   draw.fillStyle = COL;
   draw.fillRect(x0,y0,w0,h0);
   draw.strokeStyle = '#fff';
   draw.lineWidth=2;
   draw.strokeRect(x0,y0,w0,h0);
   draw.lineWidth=1;
}

     
/**This sets the scale to that the bounding box is mapped to the
   given square*/

function doFit(X,Y) {
   var s=Y[2]/X[2];
   TRANS[0]=s;
    TRANS[1]=0;
    TRANS[2]=0;
    TRANS[3]=-s;
    TRANS[4]=Y[0]-s*X[0];
    TRANS[5]=Y[1]+s*X[1];
}


function drawDisk(CAN,x,y,r,COL) {
   var Z=[]
   for(ii=0;ii<64;++ii) {
     var t=2*Math.PI*ii/64;
     Z[2*ii+0]=x+r*Math.cos(t);
     Z[2*ii+1]=y+r*Math.sin(t);
   } 
   var P=new Poly(Z,64,COL);
   P.polyRender(CAN,true);
}

function drawDiskUnscaled(CAN,x,y,r,COL) {
   var Z=[]
   for(ii=0;ii<64;++ii) {
     var t=2*Math.PI*ii/64;
     Z[2*ii+0]=x+r*Math.cos(t);
     Z[2*ii+1]=y+r*Math.sin(t);
   } 
   var P=new Poly(Z,64,COL);
   P.polyRenderUnscaled(CAN,true);
}
