/**this is the main routine.
   It randomly updates until the
   solution is found.  The input
   is T, which is a triangulation.
   The triangulation object is
   contained in the file Triangulation.js.

   The data T.FREE is a partial list of the
   triangles of T.  Once the values (+/-1 or red/blue)
   of these triangles are specified, the remaining
   triangles are determined by the congruence
   conditions.  So, we are looking for the right
   values of T.FREE*/

function solve(T) {
  var e=1;  
  zeroStart(T);
  while(e>0) {
     test=randomImprove(T);
     e=energy(T);
  }
  assignTriangles(T,T.FREE);   //figures out remaining triangles from T.FREE
}
 

/**The variable dep is the list of remaining triangles.
   These values are determined from T.FREE.  We count
   the number of 0s in this list and that is the energy*/

function energy(T) {
  var tot=0;
  var dep=T.CORE.evaluateVector(T.FREE);
  for(var i=0;i<dep.length;++i) {
    if(dep[i]%3==0) ++tot;
  }
  return tot;
}


/**Let n be the length of T.FREE.
   This first picks a random number L
   between 1 and n-4, then randomly
   selects L of the free variables 
   to flip (from 1 to -1 or -1 to 1).
   Then it recomputes the energy of the
   new coloring. If the energy is
   not too much higher, the new coloring
   replaces the old one.*/

function randomImprove(T) {
  var test=true;
  var e0=energy(T);
  var n=T.FREELIST.length;
  var B=[];
  var L=randomLength(n);

  for(var i=0;i<L;++i) {
    B[i]=4+Math.floor((n-4)*Math.random());
  }
  cellReverse(T,B);
  var e1=energy(T); 
  if(e1<e0+L) return true;
  else cellReverse(T,B);
  return false;
}

/**Chooses the random number*/

function randomLength(n) {
  var count=1;
  var test=false;
  while(test==false) {
    var a=Math.random();
    if(a<1-4/n) return count;
    ++count;
    if(count==n-5) return count;
  }
  test=true;
}
 

/**Makes the flip*/

function cellReverse(T,B) {
   for(var j=0;j<B.length;++j) {
     var a=B[j];
     T.FREE[a]=-T.FREE[a];
   }
}
 

/**Converts the free list into 
   the coloring*/

function assignTriangles(T,free) {
  var dep=T.CORE.evaluateVector(free);
  var VEC=[];
  for(var i=0;i<T.FREELIST.length;++i) {
    T.CELL[T.FREELIST[i]][3]=free[i];
    T.FREE[i]=free[i];
  }
  T.CELL[0][3]=+1;
  T.CELL[1][3]=-1;
  T.CELL[2][3]=-1;
  T.CELL[3][3]=-1;
  T.FREE[0]=+1;
  T.FREE[1]=-1;
  T.FREE[2]=-1;
  T.FREE[3]=-1;
 
  for(var i=0;i<T.DEPENDLIST.length;++i) {
    var a=(2*dep[i])%3;
    if(a==2) a=-1;
    T.CELL[T.DEPENDLIST[i]][3]=a;
  }
  T.getSums();
}
 
/**Starts the routine with the free list being all 1's*/

function zeroStart(T) {
  var Z=[];
  var L=(T.CELLCOUNT-2)/2;
  for(var i=0;i<L;++i) {
    Z[i]=1;
  }
  assignTriangles(T,Z);
}
