
/**These are the routines which extract the graph neighbors
   from the cocycle.  The first routine is the main one.*/


function getNeighbors() {
  var n=this.LIST.length;
  this.BAD=[];
  getNeighborsEasy(this);
  getSubtle(this);
  var count=0;
  for(var i=0;i<n;++i) { 
    this.EDGE[i]=union(this.EDGE[i],this.SUBTLE[i]);
  }
  symmetrizeEdges(this);
  setBad(this);
  errorCorrect(this);
  setBad(this);
}


/**supporting routines*/


function symmetrizeEdges(T) {
  for(var i=0;i<T.LIST.length;++i) {
    for(var j=0;j<T.EDGE[i].length;++j) {
      var k=T.EDGE[i][j];
      T.EDGE[k]=union(T.EDGE[k],[i]);
    }
  }
}


function setBad(T) {
  T.BAD=[];
  var count=0;
  for(var i=0;i<T.LIST.length;++i) {
    var bad=false;
    if((T.LIST[i][0]!=0)&&(T.EDGE[i].length!=6)) bad=true;
    if((T.LIST[i][0]==0)&&(T.EDGE[i].length!=5)) bad=true;
    if(bad==true) {  
      T.BAD[count]=i;
      ++count;
    }
  }
}


function errorCorrect(T) {
  for(var i=0;i<T.BAD.length;++i) {
    for(var j=i+1;j<T.BAD.length;++j) {
      var ii=T.BAD[i];
      var jj=T.BAD[j];
      var test=errorCorrect0(T,T.BAD[i],T.BAD[j]);
      if(test==true) {
	T.EDGE[ii]=union(T.EDGE[ii],[jj]);
	T.EDGE[jj]=union(T.EDGE[jj],[ii]);
      }
    }
  }
}

function errorCorrect0(T,i,j) {
  var A=T.EDGE[i];
  var B=T.EDGE[j];
  var C=intersection(A,B);
  C=complement(C,T.BAD);
  if(C.length>1) return true;
  return false;
}


function getNeighborsEasy(T) {
  var n=T.LIST.length;
  for(var i=0;i<n;++i) {
    T.EDGE[i]=[];
    count=0;
    for(var j=0;j<n;++j) {
      var test=neighborEasy(T,i,j);
      if(test==true) {
        T.EDGE[i][count]=j;
        ++count;
      }
    }
  }
}

function neighborEasy(T,i,j) {
  var A=T.LIST[i];
  var B=T.LIST[j];
  if(i==j) return false;
  for(var l=2;l<A.length;++l) {
    for(var k=2;k<B.length;++k) {
      if(indexMatch(A[l][0],A[l][1],B[k][0],B[k][1])==true) {
        return true;
      }
    }
  }
  return false;
}



function getSubtle(T) { 
 var P=MAIN.cocyclePoly();
 var probe=[[1,0],[0,1],[-1,0],[0,-1],[1,-1],[-1,1]];
  var n=T.LIST.length;
  for(var i=0;i<n;++i) {
    T.SUBTLE[i]=[];
    count=0;
    for(var ii=2;ii<T.LIST[i].length;++ii) {
        var i0=T.LIST[i][ii][0];
        var j0=T.LIST[i][ii][1];
        for(var j=0;j<6;++j) {
          var i1=i0+probe[j][0];
          var j1=j0+probe[j][1];
	  var temp=getSubtle0(T,P,i0,j0,i1,j1);
            if(temp!=-1) {
               T.SUBTLE[i][count]=temp;
	       ++count;
	    }
	}
    }
  }
}


function getSubtle0(T,P,i0,j0,i1,j1) { 
   var test=onListVertices([i1,j1],T.LIST);
   if(test!=-1) return -1;
   var e=P.whichEdgeCross(i0,j0,i1,j1);
   if(e==-1) return -1;
   var I=MAIN.edgeMap(e,i1,j1);
   if(I==0) return -1;
   var temp=onListVertices(I,T.LIST);
   if(temp!=-1) return temp;
   /*second pass*/
   var H=MAIN.edgeMap(e,i0,j0);
   var e=P.whichEdgeCross(H[0],H[1],I[0],I[1]);
   if(e==-1) return -1;
   I=MAIN.edgeMap(e,I[0],I[1]);
   if(I==0) return -1;
   var temp=onListVertices(I,T.LIST);
   return temp;
}

 
function onListVertices(I,X) {
  for(var i=0;i<X.length;++i) {
    for(var j=2;j<X[i].length;++j) {
      if((I[0]==X[i][j][0])&&(I[1]==X[i][j][1])) return i;
    }
  }
  return -1;
}

function indexMatch(i0,j0,i1,j1) {
  if((i1==i0+0)&&(j1==j0+1)) return true;
  if((i1==i0+1)&&(j1==j0+0)) return true;
  if((i1==i0+0)&&(j1==j0-1)) return true;
  if((i1==i0-1)&&(j1==j0+0)) return true;
  if((i1==i0-1)&&(j1==j0+1)) return true;
  if((i1==i0+1)&&(j1==j0-1)) return true;
  return false;
}




