
function Writer() {
  this.FONT=[];
  for(var i=0;i<20;++i) this.FONT[i]=0;
  this.getFont=getFont;
}


/**Here is the main routine
   Z: coords of text rectangle
   CAN: the canvas
   S the strong
   C the background color
   choice: this is a preset value for the fontsize,
   computed once at the beginning. Each message
   gets its own choice value*/

function setTextBox(Z,CAN,S,C,choice) { 
  var draw = CAN.getContext('2d');
  draw.fillStyle=C;
  draw.fillRect(Z[0],Z[1],Z[2],Z[3]);
  draw.lineWidth=3; 
  draw.strokeStyle='#fff';
  draw.strokeRect(Z[0],Z[1],Z[2],Z[3]);
  draw.lineWidth=1; 
  draw.fillStyle = '#fff';
  WRITER.getFont(Z,CAN,S,C,choice);
  var min=WRITER.FONT[choice];
  SS=stringChop(CAN,S,min,Z[2]-5);
  draw.font = min.toString()+'pt Helvetica'; 
  var space=(Z[3]-10)/SS.length;
  draw.translate(0,Z[1]+space);
  for(var i=0;i<SS.length;++i) {
      var size=min;
      draw.font = size.toString()+'pt Helvetica'; 
      draw.fillText(SS[i],Z[0]+5,space*i);
    }
   draw.translate(0,-Z[1]-space);
}



/**returns the pixel length of a strong*/

function stringWidth(CAN,S,t) {
    var draw = CAN.getContext('2d');
    draw.font = t.toString()+'pt Helvetica';
    var metrics = draw.measureText(S);
    return(metrics.width);
}

/**gets a substring consisting of words a,a+1,...,b-1.*/

function stringMerge(S,a,b) {
  var T=S.split(" ");
  var U="";
  for(var i=a;i<b;++i) {
    U=U+T[i]+" ";
  }
  return(U);
}
    

/**This peels off the longest portion of the string which
   has length less than the given limit and starts at the
   given word.*/

function stringPeel(CAN,S,n,font,limit) {
  var test=false;
  var T=S.split(" ");
  var index=n;
  for(var i=n;i<=T.length;++i) {
    var U=stringMerge(S,n,i);
    if(stringWidth(CAN,U,font)<limit) index=i;
  }
  return index;
}
    
/**This splits the string into pieces that have length
   less than the limit*/

function stringChop(CAN,S,font,limit) {
  var test=false; 
  var index=[]; 
  var count=1;
  var spot1=0;
  var spot2=0;
  index[0]=0;
  var T=S.split(" ");
  var cluge=0;

  while(test==false) {
    spot2=stringPeel(CAN,S,spot1,font,limit);
    if(spot2==spot1) return undefined;
    index[count]=spot2;
    ++count;
    spot1=spot2;
    if(spot2==T.length) test=true;
    ++cluge;
  }
  var U=[];
  for(var i=0;i<count-1;++i) {
    U[i]=stringMerge(S,index[i],index[i+1]);
  }
  return U;
}

function textFits(CAN,S,font,limit,height) {
  var SS=stringChop(CAN,S,font,limit);
  if(SS==undefined) return false;
  if(1.6*SS.length*font>height) return false;
  return SS;
}


function getFont(Z,CAN,S,C,choice) {

  if(this.FONT[choice]!=0) return;
  var draw = CAN.getContext('2d');
  var test=false;
  var min=0;
  var max=20;
  var mid=10;
  var SS=[];
  var count=0;
  while(test==false) { 
    SS=textFits(CAN,S,mid,Z[2]-5,Z[3]-15);
    if(SS==false) { 
      max=mid;;
      min=min;
      mid=(max+min)/2;
    } 
    else {
      min=mid;;
      max=max;
      mid=(max+min)/2;
    }
    if(max-min<.25) test=true;
  } 
  this.FONT[choice]=min;
}

