import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/**This is just scratchwork.  We're trying to find
   the Hermition form in the octahedral stratum*/

public class AreaForm {



    public static Complex area(EnhancedPolygon E) {
	return form(E.z,E.z);
    }

    /**This routine expresses the area in terms of the independent variables*/
    
    public static Complex area(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex[] Z=getDependent(z1,z3,z8,z9);
	return area(Z);
    }

    public static Complex[] getDependent(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex z0=new Complex(0,0);
	Complex z2=W2(z1,z3,z8,z9);
	Complex z4=W4(z1,z3,z8,z9);
	Complex z5=W5(z1,z3,z8,z9);
	Complex z6=W6(z1,z3,z8,z9);
	Complex z7=W7(z1,z3,z8,z9);
	Complex[] Z={z0,z1,z2,z3,z4,z5,z6,z7,z8,z9};
	return Z;
    }


    /**This is the geometrical version of area which uses all the variables*/
    
    public static Complex area(Complex[] Z) {
	Complex z1=triArea(Z,0,1,2);
	Complex z2=triArea(Z,0,2,9);
	Complex z3=triArea(Z,6,7,8);
	Complex z4=triArea(Z,6,8,9);
	Complex z5=triArea(Z,2,3,4);
	Complex w1=triArea(Z,4,2,9);
	Complex w2=triArea(Z,6,4,9);
	Complex w=Complex.plus(w1,w2);
	Complex[] A={z1,z2,z3,z4,z5};
	for(int i=0;i<5;++i) {
	    w=Complex.minus(w,A[i]);
	}
	double b=Math.sqrt(3)/4;
	w=w.scale(1/b);
	return w;

    }

    public static Complex triArea(Complex[] Z,int a,int b,int c) {
	Complex z1=Z[a];
	Complex z2=Z[b];
	Complex z3=Z[c];
	Complex w1=Complex.minus(z1,z2);
	Complex w2=Complex.minus(z1,z3);
	Complex w3=Complex.times(w1,w2.conjugate());
	w3=w3.scale(.5);
	return w3;
    }




    public static Complex form(Complex[] Z,Complex[] W) {
	Complex z1=triForm(Z,W,0,1,2);
	Complex z2=triForm(Z,W,0,2,9);
	Complex z3=triForm(Z,W,6,7,8);
	Complex z4=triForm(Z,W,6,8,9);
	Complex z5=triForm(Z,W,2,3,4);
	Complex w1=triForm(Z,W,4,2,9);
	Complex w2=triForm(Z,W,6,4,9);
	Complex w=Complex.plus(w1,w2);
	Complex[] A={z1,z2,z3,z4,z5};
	for(int i=0;i<5;++i) {
	    w=Complex.minus(w,A[i]);
	}
	double b=Math.sqrt(3)/4;
	w=w.scale(1/b);
	return w;

    }




    
    public static Complex triForm(Complex[] Z,Complex[] W,int a,int b,int c) {
	Complex z1=Z[a];
	Complex z2=Z[b];
	Complex z3=Z[c];
	Complex w1=W[a];
	Complex w2=W[b];
	Complex w3=W[c];
	Complex z12=Complex.minus(z1,z2);
	Complex z13=Complex.minus(z1,z3);
	Complex w12=Complex.minus(w1,w2);
	Complex w13=Complex.minus(w1,w3);
	Complex a1=Complex.times(z12,w13.conjugate());
	Complex a2=Complex.times(z13,w12.conjugate());
	Complex a3=Complex.minus(a1,a2);
	a3=Complex.times(a3,new Complex(0,-.25));
	return a3;
    }






    
    public static void analyzePoints(Complex[] Z) {
	Complex w7=W7(Z[1],Z[3],Z[8],Z[9]);
    }

    public static Complex W2(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex a=Complex.alpha(5);
	Complex w=Complex.plus(z1,Complex.times(z1,a));
	return w;
    }

    public static Complex W4(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex z2=W2(z1,z3,z8,z9);
	Complex a=Complex.alpha(2);
	Complex w=Complex.plus(z3,Complex.times(a,Complex.minus(z2,z3)));
	return w;
    }

    

    public static Complex W5(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex z4=W4(z1,z3,z8,z9);
	Complex w=Complex.plus(z4,z9);
	return w;
    }

    public static Complex W6(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex z4=W4(z1,z3,z8,z9);
	Complex z5=W5(z1,z3,z8,z9);
	Complex w=Complex.minus(z5.scale(2),z4);
	return w;
    }

    public static Complex W7(Complex z1,Complex z3,Complex z8,Complex z9) {
	Complex z6=W6(z1,z3,z8,z9);
	Complex a=Complex.alpha(4);
	Complex b1=Complex.minus(z6,Complex.times(a,z8));
	Complex b2=Complex.plus(new Complex(1,0),Complex.alpha(5));
	b2=b2.scale(1.0/3);
	Complex w=Complex.times(b1,b2);
	return w;
    }

    public static Complex pair(Complex[] U,Complex[] W) {
	Complex H=new Complex(0,0);
	for(int i=0;i<4;++i) H=Complex.plus(H,Complex.times(U[i],W[i]));
	return H;
    }




    public static Complex[] trial() {
	double s=Math.sqrt(3)/2;
	double a=Math.random();
	double b=Math.random();
	double c=Math.random();
	double d=Math.random();

	double e=a+b-d;
	double f=-a+c+d;
	Complex z0=new Complex(0,0);
	Complex z1=new Complex(f/2+e,-s*f);
	Complex z3=Complex.plus(z1,new Complex(f+e/2+a/2,s*e-s*a));
	Complex z8=new Complex(f/2-e/2,-s*e-s*f);
	Complex z9=new Complex(-a-b/2,-s*b);

	z1=z1.conjugate();
	z3=z3.conjugate();
	z8=z8.conjugate();
	z9=z9.conjugate();

	
	Complex z2=W2(z1,z3,z8,z9);
	Complex z4=W4(z1,z3,z8,z9);
	Complex z5=W5(z1,z3,z8,z9);
	Complex z6=W6(z1,z3,z8,z9);
	Complex z7=W7(z1,z3,z8,z9);
	Complex[] Z={z0,z1,z2,z3,z4,z5,z6,z7,z8,z9};
	return Z;
    }
	
}

