import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    SelectColor CS;
    ControlPanel STRATUM;
    SearchRandomizer SEA;
    ListenSquare RESET,GEOM;
    Solver SOL;
    String[] STR=new String[5];
    PopupManager POP;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(M,0,156,399,60);
	 setScales(200,200,50);
	 SOL=new Solver();
	 SEA=new SearchRandomizer(25,30);
	 for(int i=0;i<5;++i) STR[i]="";

     }

    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawMessage(g);
      SEA.render(g);
      POP.render(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(100,120,140));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }
    
    public void drawMessage(Graphics2D g) {
      g.setFont(new Font("Helvetica",Font.PLAIN,14));
      g.setColor(Color.white);
      for(int i=0;i<5;++i) g.drawString(STR[i],10,80+20*i);
    }
    
    public void drawControls(Graphics2D g) { 
      CS.render(g);
    }

    public void switchStratum(Point X) {
	int t=STRATUM.switchMode(X);
    }



    
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
        CS.process(e);
	SEA.process(e);
	POP.process(J.X);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	}
	M.repaint();
    }


    
    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	M.repaint();
     } 

}

    
