import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.util.Arrays;


public class GraphAnalyzer {
    

    public static void setTriangles(EnhancedPolygon E) {
	setTriangleList(E);
	setFlowerList(E);
	setTriangleIncidence(E);
    }

    
	

    /**This routine gets the complete list of flowers and the complete list of triangles*/

    public static void setFlowerList(EnhancedPolygon E) {
	int n=E.graph.length;
	int[][] f=new int[n][6];
	
        for(int i=0;i<n;++i) {
	   int[] T=E.graph2[i];
	   for(int j0=0;j0<T.length;++j0) {
	      int j1=(j0+1)%T.length;
	      int[] A={i,T[j0],T[j1]};
	      Arrays.sort(A);
	      int test=ListHelp.position(A,E.triangles);
	      f[i][j0]=test;
	   }
	   f[i]=ListHelp.trim(f[i],T.length);
	}
	E.flower=f;
    }



    public static void setTriangleList(EnhancedPolygon E) {
	int n=E.graph.length;
	int count=0;
	int[][] list=new int[6*n][3];
	for(int i=0;i<n;++i) {
	    int[] T=E.graph2[i];
	    for(int j0=0;j0<T.length;++j0) {
		int j1=(j0+1)%T.length;
		int[] A={i,T[j0],T[j1]};
		Arrays.sort(A);
   		list[count]=A;
		++count;
	    }
	}
	list=ListHelp.trim(list,count);
	list=ListHelp.irredundant(list);
	E.triangles=list;
    }


    public static void setTriangleIncidence(EnhancedPolygon E) {
	int n=E.triangles.length;
	E.triangles2=new int[n][3];
	for(int i=0;i<n;++i) {
	    E.triangles2[i]=getIncident(E,i);
	}
    }


    

    /**tests if two vertices are neighbors*/

    public static boolean neighbors(EnhancedPolygon E,int i,int j) {
  	if(ListHelp.onList(i,E.graph[j])==true) return true;
	return false;
    }


    /**tests if all three are common neighbors of a vertex*/
    
    public static boolean neighborsEnhanced(EnhancedPolygon E,int q,int i,int j) {
	int[] t={q,i,j};
	Arrays.sort(t);
	int pos=ListHelp.position(t,E.graph);
	if(pos!=-1) return false;
  	if(ListHelp.onList(i,E.graph[j])==true) return true;
	return false;
    }

    
    /**This gets all the vertices incident to a given triangle*/
    
    public static int[] getIncident(EnhancedPolygon E,int t) {
	int[] list=new int[3];
	int count=0;
	for(int i=0;i<E.flower.length;++i) {
	    if(ListHelp.onList(t,E.flower[i])==true) {
		list[count]=i;
		++count;
	    }
	}
	return list;
    }

    /**This tells if 2 triangles are adjacent*/

    public static boolean isAdjacent(EnhancedPolygon E,int t1,int t2) {
	int[] a1=getIncident(E,t1);
	int[] a2=getIncident(E,t2);
	int[] b=ListHelp.intersection(a1,a2);
	if(b.length==2) return true;
	return false;
    }

    /**gets list of adjacent triangles*/
    public static int[] adjacent(EnhancedPolygon E,int t) {
	int[] list=new int[3];
	int count=0;
	for(int i=0;i<E.triangles.length;++i) {
	    if(isAdjacent(E,t,i)==true) {
		list[count]=i;
		++count;
	    }
	}
	return ListHelp.trim(list,count);
    }


}
  
