import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.util.Arrays;


public class GraphEmbed {

    public static void setGeometry(EnhancedPolygon E) {
	initGeometry(E);
        improveGeometry(E,50000);
    }

    public static void initGeometry(EnhancedPolygon E) {

	E.embed=new Complex[E.graph.length];
	for(int i=0;i<E.graph.length;++i) {
	    E.embed[i]=new Complex(0,0);
	}


	int[] T=ListHelp.copy(E.graph2[E.INFINITE]);
	int k=T.length;
	
	for(int i=0;i<k;++i) {
	    double t=2*Math.PI*i/k;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    if(T[i]>999) T[i]=T[i]-1000;
    	    E.embed[T[i]]=new Complex(c,s);
	}
    }

    public static void improveGeometry(EnhancedPolygon P, int k) {
	for(int i=0;i<k;++i) improveGeometry0(P);
    }
        
    public static void improveGeometry0(EnhancedPolygon E) {
	int t=(int)(Math.random()*E.graph.length);
	int I=E.INFINITE;
	if(t==I) return;
	if(ListHelp.onList(t,E.graph[I])==true) return;

	int[] T=E.graph[t];
	int l=T.length;
	Complex q=new Complex(0,0);
	
	for(int i=0;i<l;++i) {
	    q=Complex.plus(q,E.embed[T[i]]);
	}
	q=q.scale(1.0/l);
	E.embed[t]=q;
    }

    public static double linkRadius(EnhancedPolygon E,int i) {
	double min=1;
       int[] t=E.graph[i];
       for(int j=0;j<t.length;++j) {
	   int k=t[j];
	   double d=1;
	   try{
              d=Complex.dist(E.embed[i],E.embed[k]);
	   }
	   catch(Exception e) {}
	   if(d<min) min=d;
       }
       return min;
    }
       



}



  
