import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.util.Arrays;


public class GraphFlowerImprover {

    /**This routine further improves the graph by looking for
       defective flowers. A flower is the list of triangles incident to a given vertex*/
    
    public static void improve(EnhancedPolygon E) {
	int count=0;
	for(int i=0;i<10;++i) improveFlower(E);
	
	E.PERFECT=true;
	E.graph2=new int[E.graph.length][0];
	for(int i=0;i<E.graph.length;++i) {
	    E.graph2[i]=setFlower(E,i);
	    boolean test2=isGoodFlower(E,i);
	    if(test2==false) E.PERFECT=false;
	}
    }


    /**Finds and corrects the first bad flower*/

    public static void improveFlower(EnhancedPolygon E) {
	for(int i=0;i<E.graph.length;++i) {
	    int[] A=badFlower(E,i);
	    if(A!=null) {
		addEdge(E,A);
		return;
	   }	    
	}
    }
  

    /**This adds an edge to a graph*/
    
    public static void addEdge(EnhancedPolygon E,int[] A) {
	if(A==null) return;
	int i0=A[0];
	int i1=A[1];
	E.graph[i0]=ListHelp.append(E.graph[i0],i1);
	E.graph[i1]=ListHelp.append(E.graph[i1],i0);
	Arrays.sort(E.graph[i0]);
	Arrays.sort(E.graph[i1]);
    }




    

    /**This finds a pair of integers in a flower sequence
       that has the form 2,...,2,1,1 or some permutation of that.
       The corresponding vertices should be connected in the graph*/

    public static int[] badFlower(EnhancedPolygon E,int k) {
	int[] L=flowerSequence(E,k);
	int[] F=E.graph[k];
	if(L.length<6) return null;
	int[] list=new int[L.length];
	int count=0;
	for(int i=0;i<L.length;++i) {
	    if(L[i]==1) {
		list[count]=F[i];
		++count;
	    }
	}
	if(count!=2) return null;
	int[] A=new int[2];
	A[0]=list[0];
	A[1]=list[1];
	return A;
    }


    /**This tests if the flower sequence is good*/
    
    public static boolean isGoodFlower(EnhancedPolygon E,int k) {
	int[] q=flowerSequence(E,k);
	for(int i=0;i<q.length;++i) {
	    if(q[i]!=2) return false;
	}
	return true;
    }
    
     public static int[] flowerSequence(EnhancedPolygon E,int k) {
   	int[] t=E.graph[k];
	int[] list=new int[t.length];
	for(int i=0;i<t.length;++i) {
	    int count=0;
	    for(int j=0;j<t.length;++j) {
 		boolean test=GraphAnalyzer.neighborsEnhanced(E,k,t[i],t[j]);
		if(test==true) ++count;
	    }
	    list[i]=count;
	}
	return list;
     }




    /**This routine corrects the flower order.  We want to augment the list t*/

     public static int[] setFlower(EnhancedPolygon E,int k) {
	int[] t={E.graph[k][0]};
	for(int i=0;i<t.length;++i) {
	    if(E.graph[t[i]].length==2) System.out.println("used");
	}
	boolean test=false;
	while(test==false) {
	    t=nextNode(E,k,t);
	    if(t.length==E.graph[k].length) test=true;
	}
	return t;
    }

    public static int[] nextNode(EnhancedPolygon E,int k,int[] t) {
	int[] T=E.graph[k];
	
	if(t.length==T.length) return t;
	for(int i=0;i<T.length;++i) {
	    int j=T[i];
	    if(ListHelp.onList(j,t)==false) {
		int last=t[t.length-1];
		boolean test=GraphAnalyzer.neighborsEnhanced(E,k,last,j);
		if(test==true) return ListHelp.append(t,j);
	    }
	}
	return T;
    }


    
}
  
