#! /usr/bin/tclsh
package require Tk

set HEIGHT 1000
canvas .plot -width 1000 -height $HEIGHT 
pack .plot
canvas .post -width 1000 -height 20 -bg white
pack .post
set SIZE 980

.post create rectangle 0 0 80 20 -fill blue -tag export
.post create rectangle 90 0 110 20 -fill green -tag size

.post create text 220 10 -anchor e -fill white -text $SIZE -tag pixsize
.post create text 10 10 -text "export" -anchor w -fill white -tag export
.post create text 170 10 -text "pix size" -anchor e -fill white -tag export


.post bind size <Button-1> {
global SIZE
    set SIZE [expr $SIZE-20]
.post itemconfigure pixsize -text $SIZE
}

.post bind size <Button-2> {
global SIZE
    set SIZE [expr $SIZE+20]
.post itemconfigure pixsize -text $SIZE
}


.post bind size <Button-3> {
global SIZE
    set SIZE [expr $SIZE+20]
.post itemconfigure pixsize -text $SIZE
}




.post bind export <Any-Button> post
global HEIGHT

#################
source graph
#################


.plot create oval 0 0 0 0 -fill black -outline black -tag X -width 5
.plot scale X 0 0 200 -200 
.plot move X 80 190
.plot itemconfigure X -width 2


.plot create rectangle 0 0 1000 $HEIGHT -fill white  -tag bg
.plot create rectangle 0 0 1000 [expr $HEIGHT-0] -outline white -tag fg
.plot lower bg
.plot raise fg


proc post {} {
global SIZE HEIGHT
.plot postscript -pageheight $SIZE \
-height $HEIGHT -width 1000 \
-file "temp.ps"
}

######SCALING######################
set ACOORD 0
set BCOORD 0
set SCALE 1

bind .plot <Button-1> {location %x %y
		       up_scale}

bind .plot <Button-2> {location %x %y
   	               dn_scale}

bind .plot <Button-3> {location %x %y
   	               dn_scale}

proc location {a b} {
global ACOORD BCOORD
set ACOORD $a
set BCOORD $b
}

proc up_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 11.0/10.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}


proc dn_scale {} {
global ACOORD BCOORD SCALE 
set sc [expr 10.0/11.0]
set SCALE [expr $SCALE*$sc]
.plot scale X $ACOORD $BCOORD $sc $sc
}
######################################
