import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;




public class PolygonData {



    public static EnhancedPolygon stratum(int k,Complex z) {
	int[] D=z.toEis();
	EnhancedPolygon E=stratum(k,D[0],D[1]);
	return E;
    }
    

    public static EnhancedPolygon stratum(int k,int D0,int D1) {
	int[] D={D0,D1};
	if(k==0) return stratum0(D);
	if(k==1) return stratum1(D);
	if(k==2) return stratum2(D);
	if(k==3) return stratum3(D);
	return null;
    }
    

    public static EnhancedPolygon stratum0(int[] D) {
	EnhancedPolygon E=new EnhancedPolygon();
	E.count=22;
	E.control_point=1;
	E.free=PolygonData.poly0Free();
	E.pair=PolygonData.poly0Pair();
     	E.holo=PolygonData.poly0Holo();
	E.geom=PolygonData.poly0Geom();
	E.geom=inflate(D,E.geom);
	E.degrees=PolygonData.poly0Deg();
	return E;
    }

    public static EnhancedPolygon stratum1(int[] D) {
	EnhancedPolygon E=new EnhancedPolygon();
	E.count=10;
	E.control_point=1;
	E.free=PolygonData.poly1Free();
	E.pair=PolygonData.poly1Pair();
     	E.holo=PolygonData.poly1Holo();
	E.geom=PolygonData.poly1Geom();
	E.geom=inflate(D,E.geom);
	E.degrees=PolygonData.poly1Deg();
	return E;
    }
    
    public static EnhancedPolygon stratum2(int[] D) {
	EnhancedPolygon E=new EnhancedPolygon();
	E.count=6;
	E.control_point=1;
	E.free=PolygonData.poly2Free();
	E.pair=PolygonData.poly2Pair();
     	E.holo=PolygonData.poly2Holo();
	E.geom=PolygonData.poly2Geom();
	E.geom=inflate(D,E.geom);
	E.degrees=PolygonData.poly2Deg();
	return E;
    }

    public static EnhancedPolygon stratum3(int[] D) {
	EnhancedPolygon E=new EnhancedPolygon();
	E.count=4;
	E.control_point=1;
	E.free=PolygonData.poly3Free();
	E.pair=PolygonData.poly3Pair();
     	E.holo=PolygonData.poly3Holo();
	E.geom=PolygonData.poly3Geom();
	E.geom=inflate(D,E.geom);
	E.degrees=PolygonData.poly3Deg();
	return E;
    }



    
    /**inflating the geometry*/

    public static int[][] inflate(int[] D,int[][] k) {
	int n=k.length;
	int[][] l=new int[n][2];
	for(int i=0;i<n;++i) {
	    Complex z=Complex.eis(k[i][0],k[i][1]);
	    Complex w=Complex.eis(D[0],D[1]);
	    z=Complex.times(z,w);
	    l[i]=z.toEis();
	}
	return l;
    }


    /**Here is the 5...5 stratum*/
      public static int[] poly0Free() {
	int[] a={1,1,1,0,0,1,1,0,0,1,0,0,1,1,0,0,1,1,0,0,0,1};  //0th variable (1) is the origin*/
	return a;
    }

    public static int[] poly0Pair() {
	int[] b={3,2,1,0,7,6,5,4,9,8,21,14,13,12,11,18,17,16,15,20,19,10};
	return b;
    }

    public static int[] poly0Holo() {
	int[] c={0,0,4,5,0,0,4,5,0,4,3,0,0,4,5,0,0,4,5,5,0,0};
	return c;
    }

    
    public static int[][] poly0Geom() {
	int[][] d={{0,0},{1,0},{2,0},{3,-1},{3,0},{4,0},{4,1},{3,1},{2,2},{2,1},{0,1}};
	return d;
    }
    
    public static int[] poly0Deg() {
	int[] d={5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5};
	return d;
    }


    /**Here is the 444444 stratum*/
    public static int[] poly1Free() {
	int[] a={1,1,0,1,0,0,0,0,1,1};  //0th variable (1) is the origin*/
	return a;
    }

    public static int[] poly1Pair() {
	int[] b={1,0,3,2,9,8,7,6,5,4};
	return b;
    }

    public static int[] poly1Holo() {
	int[] c={0,5,0,5,3,5,4,0,0,0,0};
	return c;
    }

    public static int[][] poly1Geom() {
	int[][] d={{0,0},{1,0},{2,0},{0,1},{-1,1}};
	return d;
    }

    public static int[] poly1Deg() {
	int[] d={4,4,4,4,4,4,4,4,4,4};
	return d;
    }



    /**Here is the 3333 stratum*/
    public static int[] poly2Free() {
	int[] a={1,1,0,0,0,1};  //0th variable (1) is the origin*/
	return a;
    }

    public static int[] poly2Pair() {
	int[] b={1,0,5,4,3,2};
	return b;
    }

    public static int[] poly2Holo() {
	int[] c={0,0,3,3,0,0};
	return c;
    }

    public static int[][] poly2Geom() {
	int[][] d={{0,0},{1,0},{0,1}};
	return d;
    }

    public static int[] poly2Deg() {
	int[] d={3,3,3,3,3,3};
	return d;
    }



    /**Here is the 222 stratum*/
    public static int[] poly3Free() {
	int[] a={1,1,0,0};  //0th variable (1) is the origin*/
	return a;
    }

    public static int[] poly3Pair() {
	int[] b={1,0,3,2};
	return b;
    }

    public static int[] poly3Holo() {
	int[] c={0,1,2,0};
	return c;
    }

    public static int[][] poly3Geom() {
	int[][] d={{0,0},{1,0}};
	return d;
    }

    public static int[] poly3Deg() {
	int[] d={2,2,2,2};
	return d;
    }






    
}





        
