import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends Canvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    ListenSquare RESET;
    PolygonControl PC;
    IterationControl ItC;



     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 PC=new PolygonControl(0,5);
	 ItC=new IterationControl(0,9,M);
	 RESET=new ListenSquare(75,5,40,20,null);RESET.on=1;
     }

    public ControlCanvas addManager(Manager M) {
	ControlCanvas PP=this;
	PP.M=M;
	return(PP);
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      PC.render(g);
      ItC.render(g);
      RESET.render(g,Color.blue);  
      g.setFont(new Font("Helvetica",Font.PLAIN,12));
      g.setColor(Color.white);
      g.drawString("reset",82,20);

   }

   public void drawBG(Graphics2D g) {
        g.setColor(new Color(50,0,100));
        g.fillRect(0,0,getWidth(),getHeight()); 
        g.setColor(Color.white);
        g.drawRect(0,0,getWidth()-1,getHeight()); 
   }

    public void selectPolygon(MouseEvent e) {
	int test=PC.process(e,Color.white);
	int n=PC.getSides();
	if(test==99) { 
            M.P.setPolygons(n,1);
	    ItC.A.CONVEX=false;
	    ItC.A.COUNT=0;
	    M.T.clear();
	    M.T.repaint();
	}
    }

    public void selectIteration(MouseEvent e) {
	int test=ItC.process(e);
    }

    public void doReset() { 
	M.I.V[0]=M.P.V[0];
	ItC.A.COUNT=0;
	ItC.A.CONVEX=false;
	M.T.clear();
	M.T.repaint();
    }

    public void mouseClicked(MouseEvent e) {
	ItC.M=this.M;
        MouseData J=MouseData.process(e);
	selectPolygon(e);
	selectIteration(e);
	if(RESET.inside(J.X)==1) doReset();
	repaint();
	M.P.repaint();
	M.I.repaint();
    }



    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     }



    public void keyPressed(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {
	ItC.processKey(e);
	repaint();
    }
    public void keyReleased(KeyEvent e) {
    }


}

