import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;

public class DocumentCanvas extends Canvas 
implements MouseListener {
    
    Manager M;
    String[] S=new String[500];
    String[] P=new String[500];
    int paragraphs;
    int linecount;
    String MAIN;
    ListenSquare F;
    SelectInteger I1,I2,I3,I4;
    Integer[] J=new Integer[200];
    ListenSquare L;
    Color COLOR1;
    Color COLOR2;
    
    

    public DocumentCanvas addManager(Manager M) {
	DocumentCanvas XX=this;
	XX.M=M;
	return(XX);
    }
    
    public DocumentCanvas() {
        addMouseListener(this);
        setBackground(new Color(50,0,100));
        I2=new SelectInteger(25,5,40,20,0,0,199,1);
        I4=new SelectInteger(115,5,40,20,5,1,20,1);
        I3=new SelectInteger(205,5,40,20,12,8,22,1);


        for(int i=0;i<=199;++i) J[i]=new Integer(i);
        L=new ListenSquare(2,2,12,12,Color.black);
        L.on=1;
        paragraphs=0;
        setup();
	COLOR1=new Color(0,80,160);
	COLOR2=Color.white;
    }
    
    
    
    public int wordBreak(String A,int n) {
        String AA=new String();
        for(int i=n;i>0;--i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo(" ")==0) return(i);
        }
        return(n);
    }
    
    
    public void findBreaks(String A) {
        int count=0;
        int pos1=0;
        String AA=new String();
        for(int i=0;i<A.length();++i) {
            AA=A.substring(i,i+1);
            if(AA.compareTo("\n")==0) {
                P[count]=A.substring(pos1,i);
                ++count;
                pos1=i;
            }
        }
        P[count]=A.substring(pos1,A.length());
        ++count;
        paragraphs=count;
    }
    
    
    
    public void paragraphDisplay(String A,int n) {
        
        int L=A.length();
        String AA=new String();
        int pos1=0;
        int pos2=0;
        int count=0;
        int LL=L;
        while(LL>0) {
            pos2=pos1+n;
            if(pos2>=L) {
                S[count+linecount]=A.substring(pos1,L);
                LL=0;
            }
            
            if(pos2<L) {
                pos2=wordBreak(A,pos2);
                S[count+linecount]=A.substring(pos1,pos2);
                ++count;
                LL=LL-(pos2-pos1);
                pos1=pos2;
            }
        }
        linecount=linecount+count+1;
    }
    
    
    
    
    
    public void display(int n) {
        for(int i=0;i<=499;++i) S[i]="";
        findBreaks(MAIN);
        linecount=0;
        for(int i=0;i<paragraphs;++i) {
            paragraphDisplay(P[i],n);
        }
    }
    
    
    
    public void paint(Graphics gfx) {
        
        
        Graphics2D g=(Graphics2D) gfx;
        
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);

	g.setColor(COLOR1);
	g.fillRect(30,50,getWidth()-31,getHeight()-22);
	g.setColor(Color.white);
	g.drawRect(30,50,getWidth()-31,getHeight()-22);
        
        I2.render(g,Color.blue,Color.white,new Color(100,180,255));
        I3.render(g,Color.blue,Color.white,new Color(100,180,255));
        I4.render(g,Color.blue,Color.white,new Color(100,180,255));

	g.setColor(new Color(100,180,255));
	g.drawString("scroll pos",20,40);
	g.drawString("scroll stepsize",100,40);
	g.drawString("font size",210,40);
        
        g.setFont(new Font("Helvetica",Font.PLAIN,I3.val));
        int space=I3.val+3;
	display(2*getWidth()/(2+I3.val));
        Dimension D=this.getSize();
        for(int i=0;i<=499;++i) {
            
            if(45+space*i<D.height-space+5) {
                g.setColor(new Color(100,180,255));
                g.drawString(J[i+I2.val].toString(),5,68+space*i);
		g.setColor(COLOR2);
                g.drawString(S[i+I2.val],35,68+space*i);
            }
        }
        
        g.setColor(Color.white);
        g.drawRect(0,0,D.width-1,D.height-1);
        
    }
    
    
    
    
    
    
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {}
    public void mouseEntered(MouseEvent e) {}
    public void mouseExited(MouseEvent e) {}
    public void mouseClicked(MouseEvent e) {
        Point X=new Point();
        e.consume();
        X.x=e.getX();
        X.y=e.getY();

        I2.modify(X);
        I3.modify(X);
        I4.modify(X);
        I2.step=I4.val;
        if(L.inside(X)==1) setup();
        repaint();
    }
    
    public void setup() {
        I2.val=0;
	String S="\nProjective Heat Flow\nby Rich Schwartz\n\n";

	S=S+"THIS WINDOW\n\nThis window gives explanations for the rest of the program.\n   1. scroll the text using the left arrow keys at the top.\n   2. change the scroll stepsize using the middle arrow keys at the top.\n   3. change the text size using the right arrow keys at the top.\n There are 112 lines of text.";

	    S=S+"\n\nPURPOSE\n\n";

	    S=S+"The purpose of this program is to demonstrate a projectively natural averaging process which has properties similar to heat flow: The operation defines a map on the space of projective classes of convex polygons, and (it seems that) the class of the regular polygon is the unique attracting fixed point.  It seems that, actually, the same statements hold true in the larger space of projective classes of general polygons, but I'm not sure. You can judge for yourself.\n\n";


	S=S+"PROGRAM OVERVIEW\n\nThis program has 5 windows:\n   1. documentation (this window)\n   2. polygon selector (top left)   \n   3. iteration control (top middle)\n   4. iteration display (top right)\n   5. message window(bottom left)\n I'll explain these windows in more detail below.  \n\n";


	S=S+"MOUSE COMPATIBILITY\n\nThis program works best with a 3-button mouse, but if you don't have a 3-button mouse, you can use certain keys instead. Here is the scheme:\nz: zoom in\nx select point (only relevant for top left window.)\nc: zoom out.\nThere is some text just below the top right window which reminds you of this scheme.\n\n";

	S=S+"OPERATING CONSTRUCTIONS.\n\n";
	S=S+"1. On the top left window, you change the polygon by selecting a point.  This causes the nearest point of the polygon to move to the new location. You can do this continuously by dragging the mouse with the middle button. Alternatively, hold down the x-key and move the mouse.  The arrow keys at the top let you specify a polygon with more or fewer sides.\n\n";
	S=S+"2. Once you select a polygon, it appears on the top right window. You can normalize the image in one of 3 ways, either not at all, or by a similarity, or by a projective transformation which makes the first points the vertices of the unit square.\n\n";
	S=S+"3. Once you've selected a polygon, set the action either to 'single' or to 'movie' and push the go button.  In the `single' mode, you just see the first iterate of the map. In the 'movie' mode you see the iterates done rapidly in sequence.\n\n";

	S=S+"4. The `speed' arrow keys control the speed of the animation.\n\n";
	S=S+"5. You can select many different maps.  The basic map is called the heat map.  The display control panel allows you to see the construction for the heat map.";

	S=S+"\n\nTHE HEAT MAP\n\n";
	S=S+"Here is a description of the heat map.  Given a polygon P, the map produces a polygon Q which is inscribed in P.  Think of P as having odd-labeled vertices and Q as having even-labeled vertices.  The point Q4 lies on the edge P3P5 so that there is a projective involution having action\nP1 <--> P7\nP3 <--> P5\nQ4 <--> Q4.\nThe other Q points are defined by cyclically shifting the indices in the obvious way. This construction can be done using straight lines, and you can see it by setting the display to `yes'.  This display works best for polygons which are close to regular.  In particular, if you use the projective normalization of the polygon, the construction display looks a little bit strange because some lines intersect at infinity.";

	S=S+"\n\nTHE OTHER MAPS\n\n";
	S=S+"The program lets you select a word in the numbers 1,2,3,4.  The letters correspond to the following maps\n1. heat map\n 2. dual of heat map\n 3.pentagram map\n 4.dual (i.e. inverse) of pentagram map\n  For instance, the string '13' selects the composition of the heat map with the pentagram map. You select the word by clicking on the 'word' field and using the keys to type.  I did not worry too much about how the maps I define change the labelings on the polygons. To correct for this, you can use the cyan arrow keys.  If you set the cyan arrow key to k, the computer will shift the indices by k after performing the map.  In this way, you can find the map which does the best thing to the labels.";

	S=S+"\n\nDISPLAY OF INVARIANTS\n\n";
	S=S+"When you run the movie, the message window shows two quantities, at least in the convex case.  The first quantity is max(Y)-min(Y), where Y1,...,Yn is the list of cross ratio invariants.  These (Y)s are the variables that Glick uses in the cluster description of the pentagram map.  If max(Y)-min(Y) converges to 0 it means that the polygon converges to projectively regular.  The second quantity is the product of the (Y)s, which I sometimes call the projective energy of the polygon.  I defined the basic map in the hopes that it would always increase the projective energy, thereby helping in the proof of the conjecture that the projective energy is maximized on the projectively regular class.\n\n This approach is doomed to failure, however.  Since the map '12' has more than one attractor (and presumably the energy conjecture is true), the heat map cannot always increase projective energy.  The problem is that the dual map would also have to increase the projective energy, and then '12' would increase the projective energy...I won't go through the logic of the whole argument.  Let me know if you are interested and I can explain it more clearly.  In any case, even though these maps don't help me prove the energy conjecture, they're pretty neat and I'd like to rigorously establish the properties above.";

	MAIN = new String(S);
    }
    
    public void setExplain(String doc) {
        I2.val=0;
        MAIN=doc;
        repaint();
    }
    
}

