import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class IterationCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    PolyVector[] V=new PolyVector[10];
    Color[] COLOR=new Color[10];
    int COUNT;
    Vector[] POINT=new Vector[100000];
    int count;
    Point JX;

     public IterationCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(300,150,120);
	 count=1;
	 setPolygons();	
	 COUNT=0;
     }

    public IterationCanvas addManager(Manager M) {
	IterationCanvas PP=this;
	PP.M=M;
	return(PP);
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBg(g);
      drawPolygons(g);
      if(M.C.ItC.DISPLAY.mode==1) drawConstruction(g);
   }



    public void setPolygons() {
	V[0]=PolyVector.regular(7,1);
	V[0]=Reshape.reshape(V[0],2);
    }



   public void drawBg(Graphics2D g) {
       Color C=Color.black;
	  g.setColor(C);
          g.fillRect(0,0,getWidth(),getHeight());
      }


    public void drawPolygons(Graphics2D g) {
        drawMyPoly(g,V[0],Color.blue,Color.white);
	Vector X=V[0].V[0];
	Complex z=new Complex(X.x[0],X.x[1]);
	fillPoint(g,z,.02,Color.cyan,50);
    }

    public void drawConstruction(Graphics2D g) {
	V[3]=NewMap.map1(V[0]);
	drawMyPoly(g,V[3],new Color(0,180,0),new Color(0,0,200));
	GeneralPath gp=V[0].toGeneralPath2();
        drawMyPath(g,gp,new Color(0,0,0,0),Color.cyan);
	V[1]=NewMap.penta2(V[0]); 
        gp=V[1].toGeneralPath2();
	V[2]=NewMap.penta1(V[0]);
        drawMyPath(g,gp,new Color(0,0,0,0),Color.cyan);
	gp=PolyVector.toGeneralPath(V[1],V[2]);
        drawMyPath(g,gp,new Color(0,0,0,0),Color.cyan);
    }

    public void drawMyPoly(Graphics2D g,PolyVector P,Color C1,Color C2) {
        GeneralPath gp=P.toGeneralPath();
	drawMyPath(g,gp,C1,C2);
    }

    public void drawMyPath(Graphics2D g,GeneralPath gp,Color C1,Color C2) {
	gp=transform(gp);
	g.setColor(C1);
        g.fill(gp);
        g.setColor(C2);
	g.draw(gp);
    }



    public void printInvariants() {
	double[] d=XInvariants.invariant(V[0]);
	System.out.println("invariants");
	for(int i=0;i<d.length;++i) System.out.println(d[i]);
    }




    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int mode=J.mode;
	if(mode!=2) {
	    doScale(e,M);
	}
	repaint();
    }

    public void doMouseClick(int mode) {
	if(mode!=2) {
	    doScale(mode,JX);
	}
  	if(mode==4) printInvariants();
	repaint();
    }
    public void mousePressed(MouseEvent e) { }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=J.X;
     }

     public void mouseDragged(MouseEvent e) {
     }


    public void keyPressed(KeyEvent e) {
	int test=-100;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;   //zoom in
	if(ch=='c') test=3;   //zoom out
	if(ch=='q') test=4;   //print invariants
        doMouseClick(test);
	repaint();
    }


    public void keyTyped(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {
    }



}

