import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class IterationControl {
    ControlPanel NORMALIZE,MOVIE,DISPLAY;
    SelectInteger LIM,SPEED,CYCLE;
    ListenSquare RESET,GO,HALT;
    SelectWord WORD;
    int X,Y;
    Manager M;
    Animator A;

    public IterationControl(int x,int y,Manager M) {
	this.X=x;
	this.Y=y;
	setPanels();
	setArrows();
	A=new Animator();
    }

    public void setArrows() {
	SPEED=new SelectInteger(X+3,Y+240,40,20,5,1,60,1);
	CYCLE=new SelectInteger(X+3,Y+183,40,20,0,-20,20,1);
	GO=new ListenSquare(X,Y+270,40,21,null);
	GO.on=1;
	HALT=new ListenSquare(X+80,Y+270,40,21,null);
	HALT.on=1;	
	WORD=new SelectWord(X+5,Y+160,110,16,"1");
    }



    public void render(Graphics2D g) {
	Color C=new Color(0,220,220);
	NORMALIZE.render(g,X,Y+90,120);
	SPEED.render(g,new Color(0,200,0),Color.white,Color.white);
	CYCLE.render(g,C,Color.white,Color.white);
	MOVIE.render(g,X+60,Y+40,60);
	DISPLAY.render(g,X,Y+40,60);
	GO.render(g,new Color(0,180,0));
 	WORD.render(g,C,Color.black,Color.black,Color.black);      
        g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.white);
	if(A.halt==1) renderHalt(g);   
	g.drawString("go",(int)(GO.x+5),(int)(GO.y+15));
	g.drawString("speed?",(int)(SPEED.x),(int)(SPEED.y-5));
   }

    public void renderHalt(Graphics2D g) {
       HALT.render(g,new Color(255,0,0));
	g.drawString("halt",(int)(HALT.x+5),(int)(HALT.y+15));
    }

    public int getNormalize() {
	return(NORMALIZE.mode);
    }



    public int getMovieSpeed() {
	return(SPEED.val);
    }


    public void setPanels() {  
         Color[] C0={new Color(0,90,195),Color.white,Color.white,Color.black,new Color(180,180,180)};
	 String[] ShapeString={"none","similarity","projective","normalize polygon"};
	 int[] ShapeState={0,0,1};
         NORMALIZE=new ControlPanel(C0,ShapeString,ShapeState,3);
	 NORMALIZE.mode=2;


	 String[] MovieString={"single","movie","action"};
	 int[] MovieState={0,1};
         MOVIE=new ControlPanel(C0,MovieString,MovieState,2);
	 MOVIE.mode=1;



	 String[] DisplayString={"no","yes","display"};
	 int[] DisplayState={1,0};
         DISPLAY=new ControlPanel(C0,DisplayString,DisplayState,2);
	 DISPLAY.mode=0;
    }




    public void action() {
	if(A.halt==0) {
	    A=new Animator(this.M);
            new Thread(A).start();
	}
    }

    public int process(MouseEvent e) {
        MouseData J=MouseData.process(e);
	int test=NORMALIZE.switchMode(J.X);
	WORD.activate(J.X);
	SPEED.modify(J.X);
	CYCLE.modify(J.X);
	MOVIE.switchMode(J.X);
	DISPLAY.switchMode(J.X);
	if(HALT.inside(J.X)==1) A.halt=0;
	if(GO.inside(J.X)==1) action();
	return(0);
    }

    public void processKey(KeyEvent e) {   
        WORD.modify(e);
    }

}

