import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class NewMap {


    public static PolyVector map(SelectWord WORD,PolyVector V) {
	PolyVector W=new PolyVector(V);
	for(int i=0;i<WORD.S.length();++i) {
	    int k=WORD.getLetter(i);
	    if(k==1) W=map1(W);
	    if(k==2) {
		W=map2(W);
		W=map1(W);
		W=map2(W);
	    }
	    if(k==3) W=penta1(W);
	    if(k==4) W=penta2(W);
	}
	return(W);
    }

    public static Vector basic(Vector[] V) {
	Vector W1=Vector.cross(V[0],V[2]);
	Vector W2=Vector.cross(V[1],V[3]);
	Vector W3=Vector.cross(W1,W2);

	Vector X1=Vector.cross(V[0],V[1]);
	Vector X2=Vector.cross(V[2],V[3]);
	Vector X3=Vector.cross(X1,X2);

	Vector Y1=Vector.cross(V[1],V[2]);
	Vector Y2=Vector.cross(W3,X3);
	Vector Y3=Vector.cross(Y1,Y2);
	Y3=Y3.normalize();
	return(Y3);
    }




    public static PolyVector map1(PolyVector V) {
	PolyVector X=new PolyVector(V);
	int n=X.count;
	for(int i=0;i<n;++i) {
	    int i0=(i-1+n)%n;
	    int i1=(i-0+n)%n;
	    int i2=(i+1+n)%n;
	    int i3=(i+2+n)%n;
	    Vector[] W={V.V[i0],V.V[i1],V.V[i2],V.V[i3]};
	    X.V[i]=basic(W);
	}
	return(X);
    }

    public static PolyVector map2(PolyVector V) {
	PolyVector W=new PolyVector(V);
	for(int i=0;i<V.count;++i) {
	    int i0=i;
	    int i1=(i+1)%V.count;
	    W.V[i]=Vector.cross(V.V[i0],V.V[i1]);
	    W.V[i]=W.V[i].normalize();
	}
	return(W);
    }

    public static PolyVector cycle(int k,PolyVector V) {
	PolyVector W=new PolyVector(V);
	for(int i=0;i<V.count;++i) {
	    int i0=i;
	    int i1=(i+k+V.count)%V.count;
	    W.V[i0]=V.V[i1];
	}
	return(W);
    }

    /**here is the pentagram map.*/

    public static Vector penta01(Vector[] V) {
	Vector X1=Vector.cross(V[0],V[2]);
	Vector X2=Vector.cross(V[1],V[3]);
	Vector X3=Vector.cross(X1,X2);
	return(X3);
    }

    public static PolyVector penta1(PolyVector V) {
	PolyVector X=new PolyVector(V);
	int n=X.count;
	for(int i=0;i<n;++i) {
	    int i0=(i-1+n)%n;
	    int i1=(i-0+n)%n;
	    int i2=(i+1+n)%n;
	    int i3=(i+2+n)%n;
	    Vector[] W={V.V[i0],V.V[i1],V.V[i2],V.V[i3]};
	    X.V[i]=penta01(W);
	}
	return(X);
    }


    /**here is the dual pentagram map*/
    public static Vector penta02(Vector[] V) {
	Vector X1=Vector.cross(V[0],V[1]);
	Vector X2=Vector.cross(V[2],V[3]);
	Vector X3=Vector.cross(X1,X2);
	return(X3);
    }

    public static PolyVector penta2(PolyVector V) {
	PolyVector X=new PolyVector(V);
	int n=X.count;
	for(int i=0;i<n;++i) {
	    int i0=(i-1+n)%n;
	    int i1=(i-0+n)%n;
	    int i2=(i+1+n)%n;
	    int i3=(i+2+n)%n;
	    Vector[] W={V.V[i0],V.V[i1],V.V[i2],V.V[i3]};
	    X.V[i]=penta02(W);
	}
	return(X);
    }


}

