import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Penta {


    /**This does the basic rational map for pentagons.*/
    public static Complex[] map(Complex[] x) {
	Complex w1=coord1(x[0],x[1]);
	Complex w2=coord1(x[1],x[0]);
	Complex[] w={w1,w2};
	return(w);
    }

    /**First coordinate of rational map for pentas*/
    public static Complex coord1(Complex x,Complex y) {

	Complex z1=new Complex(-3,0);
	Complex z2=Complex.times(new Complex(2,0),Complex.times(x,y));
	Complex z3=Complex.times(Complex.times(x,y),y);
	Complex w1=Complex.plus(Complex.plus(z1,z2),z3);

	z1=new Complex(6,0);
	z2=Complex.times(z1,Complex.times(x,y));
	z3=Complex.times(Complex.times(Complex.times(x,x),y),y);
	Complex w2=Complex.minus(z1,x);
	w2=Complex.minus(w2,z2);
	w2=Complex.plus(w2,z3);

	z1=new Complex(-5,0);
	z2=Complex.times(new Complex(4,0),Complex.times(x,y));
	z3=Complex.times(Complex.times(x,y),y);
	Complex w3=Complex.plus(z1,x);
	w3=Complex.minus(w3,y);
	w3=Complex.plus(w3,z2);
	w3=Complex.plus(w3,z3);

	z1=new Complex(6,0);
	z2=Complex.times(z1,Complex.times(x,y));
	z3=Complex.times(Complex.times(Complex.times(x,x),y),y);
	Complex w4=Complex.minus(z1,y);
	w4=Complex.minus(w4,z2);
	w4=Complex.plus(w4,z3);

	Complex w5=Complex.divide(Complex.times(w1,w2),Complex.times(w3,w4));
	return(w5);
    }

    /**Hermitian norm*/

    public static double hermitianNorm(Complex[] z) {
	double d1=z[0].norm();
	double d2=z[1].norm();
	double d=d1*d1+d2*d2;
	return(Math.sqrt(d));
    }

    /**distance in C2*/
    public static double dist(Complex[] z,Complex[] p) {
	double d1=Complex.dist(z[0],p[0]);
	double d2=Complex.dist(z[1],p[1]);
	double d=d1*d1+d2*d2;
	return(Math.sqrt(d));
    }
    
    /**This produces a random point on the unit sphere*/

    public static Complex[] randomS() {	
        Complex z1=new Complex(Math.random()-.5,Math.random()-.5);
	Complex z2=new Complex(Math.random()-.5,Math.random()-.5);
	Complex[] z={z1,z2};
	double d=hermitianNorm(z);
	z1=Complex.times(new Complex(1/d,0),z1);
	z2=Complex.times(new Complex(1/d,0),z2);
	z[0]=z1;
	z[1]=z2;
	return(z);
    }

    /**This produces a random point on the sphere of radius r about
       the point p*/

    public static Complex[] randomS(double r,Complex[] p) {
	Complex[] z=randomS();
	for(int i=0;i<2;++i) {
	  z[i]=Complex.times(z[i],new Complex(r,0));
	  z[i]=Complex.plus(z[i],p[i]);
	}
	return(z);
    }

    /**This produces a random point on the boundary of the unit
       cube centered at  (.5)^2 in C2*/

    public static Complex[] randomCube() {
	double d1=Math.random();
	double d2=Math.random();
	double d3=Math.random();
	double d4=0;
	if(Math.random()>.5) d4=1;
	double s=Math.random();
	if(s<.25) {
	    Complex[] z={new Complex(d4,d1-.5),new Complex(d2,d3-.5)};
	    return(z);
	}

	if(s<.50) {
	    Complex[] z={new Complex(d1,d4-.5),new Complex(d2,d3-.5)};
	    return(z);
	}

	if(s<.75) {
	    Complex[] z={new Complex(d2,d3-.5),new Complex(d1,d4-.5)};
	    return(z);
	}

	Complex[] z={new Complex(d2,d3-.5),new Complex(d4,d1-.5)};
	return(z);
    }

    public static double[] coordRangeR(Complex[] z) {
	double[] d={10000,-10000};
	if(d[0]>z[0].x) d[0]=z[0].x;
	if(d[0]>z[1].x) d[0]=z[1].x;
	if(d[1]<z[0].x) d[1]=z[0].x;
	if(d[1]<z[1].x) d[1]=z[1].x;
	return(d);
    }

    public static double[] coordRangeI(Complex[] z) {
	double[] d={10000,-10000};
	if(d[0]>z[0].y) d[0]=z[0].y;
	if(d[0]>z[1].y) d[0]=z[1].y;
	if(d[1]<z[0].y) d[1]=z[0].y;
	if(d[1]<z[1].y) d[1]=z[1].y;
	return(d);
    }





}

