import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PolyVector {
    Vector[] V=new Vector[100];
    int count;
    int wrap;

    public PolyVector() {
	for(int i=0;i<99;++i) 
	    V[i]=new Vector();
	wrap=0;
    }

    public PolyVector(PolyVector Q) {
	this.count=Q.count;
	for(int i=0;i<Q.count;++i) this.V[i]=Q.V[i];
	this.wrap=Q.wrap;
    }

    public PolyVector normalize() {
	PolyVector P=new PolyVector();
	P.count=count;
	for(int i=0;i<count;++i) {
	    P.V[i]=V[i].normalize();
	}
	P.wrap=wrap;
	return(P);
    }


    public GeneralPath toGeneralPath() {
	PolyVector P=this.normalize();
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(P.V[0].x[0]),(float)(P.V[0].x[1]));
	for(int i=0;i<count;++i) {
	   gp.lineTo((float)(P.V[i].x[0]),(float)(P.V[i].x[1]));
	}
	gp.closePath();
	return(gp);
    }


    /**this takes the star.*/
    public GeneralPath toGeneralPath2() {
	PolyVector P=this.normalize();
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<count;++i) {
	    int i1=i;
	    int i2=(i+2)%count;
	    gp.moveTo((float)(P.V[i1].x[0]),(float)(P.V[i1].x[1]));
	    gp.lineTo((float)(P.V[i2].x[0]),(float)(P.V[i2].x[1]));
	}
	return(gp);
    }

    public static GeneralPath toGeneralPath(PolyVector Q1,PolyVector Q2) {
	PolyVector P1=Q1.normalize();
	PolyVector P2=Q2.normalize();
	GeneralPath gp=new GeneralPath();
	for(int i=0;i<P1.count;++i) {
	    gp.moveTo((float)(P1.V[i].x[0]),(float)(P1.V[i].x[1]));
	    gp.lineTo((float)(P2.V[i].x[0]),(float)(P2.V[i].x[1]));
	}
	return(gp);
    }

    public static PolyVector regular(int n) {

	PolyVector X=new PolyVector();
	X.count=n;
	for(int i=0;i<n;++i) {
	    double t=2.0*Math.PI*i/n;
	    X.V[i]=new Vector(Math.cos(t),Math.sin(t));
	}
	return(X);
    }
    
    public static PolyVector regular(int n,int c) {

	PolyVector X=new PolyVector();
	X.count=n;
	for(int i=0;i<n;++i) {
	    double t=c*2.0*Math.PI*i/n;
	    X.V[i]=new Vector(Math.cos(t),Math.sin(t));
	}
	return(X);
    }

    public PolyVector rotate(double d) {
	PolyVector X=new PolyVector();
	X.count=this.count;
	for(int i=0;i<count;++i) {
	    X.V[i]=this.V[i].rotate(d);
	}
	return(X);
    }

    public int nearestVertex(Complex z) {
	int index=-1;
	Vector W=new Vector(z);
	double min=1000000.0;
	for(int i=0;i<count;++i) {
	    double test=W.dist(W,this.V[i]);
	    if(test<min) {
		min=test;;
		index =i;
	    }
	}
	return(index);
    }



    public static double distance(PolyVector X,PolyVector Y) {
	double total=0;
	for(int i=0;i<X.count;++i) {
	    total=total+Vector.dist(X.V[i],Y.V[i]);
	}
	return(total);
    }

    public PolyVector augment(int k) {
	PolyVector X=new PolyVector();
	int n=this.count;
	X.wrap=n;
	X.count=n*k;
	for(int i=0;i<k*n;++i) {
	    X.V[i]=this.V[i%n];
	}
	return(X);
    }

    public Vector center() {

	PolyVector Y=this.normalize();
	double x0,x1;
	x0=0;
	x1=0;

	for(int i=0;i<count;++i) {
	    x0=x0+Y.V[i].x[0];
	    x1=x1+Y.V[i].x[1];
	}

	x0=x0/count;
	x1=x1/count;
	Vector V=new Vector(x0,x1,1);
	return(V);
    }

    public double inertia(double a0,double a1) {

	double total=0;
	double s=0;
	for(int i=0;i<count;++i) {
	    s=a0*V[i].x[0]+a1*V[i].x[1];
	    total=total+s*s;
	}
	return(total);
    }


    public double[][] inertiaMatrix() {

	double a00=inertia(1,0);
	double a11=inertia(0,1);
	double xxx=inertia(1,1);

	double a01=.5*(xxx-a00-a11);
	double a10=a01;

	a00=2.0*a00/count;
	a01=2.0*a01/count;
	a10=2.0*a10/count;
	a11=2.0*a11/count;

	double[][] m={{a00,a01},{a10,a11}};
	return(m);
    }

    public boolean isLocallyConvex() {
	PolyVector Q=this.normalize();
	for(int i=0;i<count;++i) {
	    int i0=i;
	    int i1=(i+1)%count;
	    int i2=(i+2)%count;
	    int i3=(i+3)%count;
	    Complex z0=new Complex(Q.V[i0].x[0],Q.V[i0].x[1]);
	    Complex z1=new Complex(Q.V[i1].x[0],Q.V[i1].x[1]);
	    Complex z2=new Complex(Q.V[i2].x[0],Q.V[i2].x[1]);
	    Complex z3=new Complex(Q.V[i3].x[0],Q.V[i3].x[1]);
	    double d1=Complex.area(z0,z1,z2);
	    double d2=Complex.area(z1,z2,z3);
	    if(d1*d2<0) return(false);
	}
	return(true);
    }

    public boolean isConvex() {
	boolean test=isLocallyConvex();
	if(test==false) return(false);
	PolyVector Q=this.normalize();
	Vector W=Q.center();
	W=W.normalize();
	double total=0;
	Complex w=new Complex(W.x[0],W.x[1]);
	for(int i=0;i<count;++i) {
	    int i0=i;
	    int i1=(i+1)%count;
	    Complex z0=new Complex(Q.V[i0].x[0],Q.V[i0].x[1]);
	    Complex z1=new Complex(Q.V[i1].x[0],Q.V[i1].x[1]);
	    z0=Complex.minus(z0,w);
	    z1=Complex.minus(z1,w);
	    Complex z2=Complex.divide(z0,z1);
	    total=total+z2.arg();
	}
	total=Math.abs(total);
	if(total<7) return(true);
	return(false);
    }



    public void print() {
	for(int i=0;i<count;++i) V[i].print();
    }

}

