import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class Reshape {

    public Reshape() {}

    /**This file contains routines which normalize the polygon
       in various ways, by applying suitable projective or
       affine transformations.*/




    public static PolyVector reshape(PolyVector X,int mode) {
	if(mode==1) return(reshapeSimilarity(X));
	if(mode==2) return(reshapeProjective(X,0));
	return(X);
    }
			   


    public static PolyVector reshapeSimilarity(PolyVector X) {
        PolyVector Y=center(X);
	Y=similarity(Y);
	Y.wrap=X.wrap;
	return(Y);
    }

    public static PolyVector reshapeProjective(PolyVector X,int vtx) {
	PolyVector Y=Normalize.reshape(X,vtx); 
	Y.count=X.count;
        Y.wrap=X.wrap;
	return(Y);
    }





    public static PolyVector center(PolyVector X) {
	PolyVector Y=new PolyVector();
	Y.count=X.count;
	Vector V=X.center();
	for(int i=0;i<X.count;++i) {
	    Y.V[i].x[0]=X.V[i].x[0]-V.x[0];
	    Y.V[i].x[1]=X.V[i].x[1]-V.x[1];
	    Y.V[i].x[2]=1;
	}
	return(Y);
    }

    public static PolyVector similarity(PolyVector X) {
	PolyVector Y=new PolyVector();
	Y.count=X.count;
	double[][] z = X.inertiaMatrix();
	double d=z[0][0]*z[1][1]-z[0][1]*z[1][0];
	double dd=Math.pow(d,-.25);
	double[][] y={{dd,0},{0,dd}};
	for(int i=0;i<Y.count;++i) {
	    Y.V[i]=X.V[i].matrixAct(y);
	}
	return(Y);
    }

}

