import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SelectCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    PolyVector[] V=new PolyVector[100];
    Color[] COLOR=new Color[100];
    int count;
    int VTX;
    int history;
    Point JX;
    boolean DRAG;


     public SelectCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(180,150,80);	
	 setPolygons(7,1);
	 history=-1;
	 count=1;
	 DRAG=false;
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);

        drawBg(g);
        drawPolygons(g);  
        drawSource(g);
   }


   public void drawBg(Graphics2D g) {
       g.setColor(new Color(100,0,255));
       g.fillRect(0,0,getWidth(),getHeight());
   }


    public void setPolygons(int n,int k) {
	V[0]=PolyVector.regular(n,k);
	int mode=2;
	try{
	 mode=M.C.ItC.getNormalize();
	}
	catch(Exception e) {}
	if(mode==2) V[0]=Reshape.reshape(V[0],2);
    }

    public void drawPolygons(Graphics2D g) {

	GeneralPath gp1=new GeneralPath();
	GeneralPath gp2=new GeneralPath();

	gp1=V[0].toGeneralPath();
	gp1=transform(gp1);
	g.setColor(new Color(50,0,100));
	g.fill(gp1);
	g.setColor(Color.white);
	g.draw(gp1);
	Complex z=new Complex();
	for(int i=0;i<4;++i) {
	   z=V[0].V[i].toComplex();
	   fillPoint(g,z,.04,Color.cyan,50);
	}
	z=V[0].V[VTX].toComplex();
	fillPoint(g,z,.04,new Color(255,255,0),50);
    }

    public void cycle() {
	V[0]=NewMap.cycle(1,V[0]);
        V[0]=Reshape.reshape(V[0],M.C.ItC.getNormalize());  
	M.I.V[0]=new PolyVector(V[0]); 
	M.I.V[0]=Reshape.reshape(M.I.V[0],M.C.ItC.getNormalize());  
    }
    public void setVertex() {
	setVertex0();
	M.I.V[0]=new PolyVector(V[0]); 
	M.I.V[0]=Reshape.reshape(M.I.V[0],M.C.ItC.getNormalize());  
    }

    public void setVertex0() {
	V[0].V[VTX]=new Vector(SOURCE);
    }

    public void findNearest() {
	int n=V[0].nearestVertex(SOURCE);
	VTX=n;
    }

    public void mouseClicked(MouseEvent e) {
      MouseData J=MouseData.process(e);
      int mode=J.mode;
	if(mode!=2) {
	   doScale(e,M);

	}
	if(mode==2) {
           doScale2(e,M);
	   findNearest();	
           setVertex();
	}
	repaint();
	M.C.repaint();
	M.I.repaint();
    }


    public void doMouseClick(int mode) {

	if((mode==1)||(mode==3)) {
	    doScale(mode,JX);
	}
	if(mode==2) {
	    doScale2(mode,JX);
	   findNearest();	
           setVertex();
	}
	if(mode==4) cycle();
	if(mode==51) specialSetting1();
	if(mode==52) specialSetting2();
	if(mode==6) printInvariants();
	repaint();
	M.C.repaint();
	M.I.repaint();
    }

    public void specialSetting1() {
	PolyVector P=new PolyVector();
	P.count=5;
	P.V[0]=new Vector(0,-4,1);
	P.V[1]=new Vector(1,5,1);
	P.V[2]=new Vector(0,4,1);
	P.V[3]=new Vector(2,18,1);
	P.V[4]=new Vector(2,-18,1);
	V[0]=Reshape.reshape(P,2);
    }

    public void specialSetting2() {
	PolyVector P=new PolyVector();
	P.count=6;
	double t=2*Math.PI/6.0;
	for(int i=0;i<6;++i) {
	    double x=Math.cos(i*t);
	    double y=Math.sin(i*t);
	    if(i%2==1) x=x*1.5;
	    if(i%2==1) y=y*1.5;
	    P.V[i]=new Vector(x,y,1);
	}
	V[0]=P;
    }

    public void printInvariants() {
	double[] d=XInvariants.invariant(V[0]);
	System.out.println("invariants");
	for(int i=0;i<d.length;++i) System.out.println(d[i]);
    }


     public void mouseMoved(MouseEvent e) {	
          MouseData J=MouseData.process(e);
	  JX=new Point(J.X);
	  if(DRAG==true) {
            doScale2(2,JX);
	    findNearest();	
            setVertex();
	  }
	  repaint();
	  M.C.repaint();
	  M.I.repaint();
     }

    public void mousePressed(MouseEvent e) { }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseExited(MouseEvent e) {}   
     
     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     } 

     public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int mode=J.mode;

	if(mode==2) {
           doScale2(e,M);
	   findNearest();	
           setVertex();
	}
	repaint();
	M.C.repaint();	
        M.I.repaint();
     }

    public void keyPressed(KeyEvent e) {
	int test=-100;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;   //zoom in
	if(ch=='x') {
            test=2; 
	    DRAG=true;
	}   
	if(ch=='c') test=3;   //zoom out
	if(ch=='v') test=4;   //cycle vertices
	if(ch=='1') test=51;   //special setting pentagon
	if(ch=='2') test=52;   //special setting hexagon
	if(ch=='q') test=6;   //print invariants
        doMouseClick(test);
	repaint();
    }


    public void keyTyped(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {
	DRAG=false;
    }

}

