import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class XInvariants {
    double x,y;
    
    public XInvariants() {}

    //vectors should be normalized to have 3rd coordinate equal to 1.

    public static double slope(Vector V1,Vector V2) {
        double s;
        s=(V2.x[1]-V1.x[1])/(V2.x[0]-V1.x[0]);
        return(s);
    }


    //inverse of usual cross ratio
    public static double cross0(double a,double b,double c,double d)
      {
      double x;
      x=(a-b)*(c-d)/((a-c)*(b-d));
      return(x);
      }


    public static double fan(Vector x,Vector a,Vector b,Vector c,Vector d) {
        double f=cross0(slope(x,a),slope(x,b),slope(x,c),slope(x,d));
        return(f);
    }



    // the local invariant
    public static double locinv(PolyVector P,int j,int ii) {
        int i;
	int n=P.count;
	PolyVector Q=P.rotate(Math.sqrt(2.0));   //a random rotation to avoid degeneracies
	int j1=(j-1*ii+n)%n;
	int j2=(j-2*ii+n)%n;
	int j3=(j-0*ii+n)%n;
	int j4=(j+1*ii+n)%n;
	int j5=(j+2*ii+n)%n;
	double ll=fan(Q.V[j1],Q.V[j2],Q.V[j3],Q.V[j4],Q.V[j5]);
        return(ll);
    }


    // the global invariants

    public static double[] invariant(PolyVector P) {
	double[] x=new double[P.count*2];

        for(int i=0;i<P.count;++i) {
             x[2*i-0]=locinv(P,i,-1);
             x[2*i+1]=locinv(P,i,1);
	}
	return(x);
    }

    public static double[] productInvariant(PolyVector P) {
	double[] x=invariant(P);
	int n=2*P.count;
	double[] y=new double[n/2];
	int i1,i2,i3;
	for(int i=0;i<n;i=i+2) {
	    i2=(i+1+n)%n;
	    i3=(i-0+n)%n;
	    y[i/2]=x[i2]*x[i3];
	}
	return(y);
    }

}


