import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Animator implements Runnable {
    Manager M;
    boolean HALT;

    public Animator() {
	HALT=true;
    }

    public Animator(Manager MM) {
	this.M=MM;
	HALT=true;
    }

    public void run() {
	int mode=M.C.ACTION.mode;
	if(mode==0) realPicture();
	if(mode==1) complexPicture();
	if(mode==2) doTests();
	if(mode==3) debug();
    }

    public void realPicture() {
	int i=0;
	int j=0;
	HALT=false;
	while(HALT==false) {
	    int choice=M.C.COLOR.val;
	    int normalize=M.C.NORMALIZE.val;
	    ++i;
            if(i==Dimension.SIZE) {
		i=0;++j;
	    }
	    if(j==Dimension.SIZE) {
		i=0;j=0;
		M.P.repaint();
	    }

	    Complex z=M.P.unTransform(i,j);
	    double[] d={z.x,z.y};
	    if(normalize==1) d=Coords.T2(d);
	    int n=DomainTest.squareNumber(d);
	    int col=ColorScheme.getRGB(choice,n);
	    M.P.IMAGE.setRGB(i,j,col);  
	}
    }

    public void complexPicture() {
	int i=0;
	int j=0;
	HALT=false;
	while(HALT==false) {
	    int choice=M.C.COLOR.val;
	    int normalize=M.C.NORMALIZE.val;
	    double x=M.N.SOURCE.x;
	    double y=M.N.SOURCE.y;
	    ++i;
            if(i==Dimension.SIZE) {
		i=0;++j;
	    }
	    if(j==Dimension.SIZE) {
		i=0;j=0;
		M.P.repaint();
	    }
	    Complex z=M.P.unTransform(i,j);
	    Complex[] d={new Complex(z.x,x),new Complex(z.y,y)};
	    int n=DomainTest.domainNumber(d);
	    int col=ColorScheme.getRGB(choice,n);
	    M.P.IMAGE.setRGB(i,j,col);
	  
	}
    }







    /**tests*/

    public void doTests() {
	int mode=M.C.TEST.mode;
	if(mode==0) cubeTest();
	if(mode==1) denomTest(1);
	if(mode==2) denomTest(2);
    }

    public void cubeTest() {
	HALT=false;
	double max=-10000;
	Complex[] p={new Complex(1.0/3,0),new Complex(1.0/3,0)};
	long count=0;
	double s=1.0/3;
	for(int i=0;i<2;++i) {
	for(int j=0;j<2;++j) {
	    for(int k=0;k<=2000;++k) {
		for(int l=0;l<=2000;++l) {
		    double x1=2*i*s;  
		    double x2=2*j*s;
		    double x3=2*s*k/2000;
		    double x4=2*s*l/2000;
		    for(int q=0;q<6;++q) {
		      Complex[] z1=cube(q,x1,x2,x3,x4); 
                      Complex[] z2=Penta.map(z1);
                      double r=3*SquareTest.infinityDist(z2,p);
		      if(max<r) {
			  max=r;
		      }
		    }
		}
	    }
	  
	}}
        System.out.println("done "+max);
	HALT=true;
	M.C.repaint();
    }



    public static Complex[] cube(int choice,double x1,double x2,double x3,double x4) {
	if(choice==0) return(cube(x1,x2,x3,x4));
	if(choice==1) return(cube(x1,x3,x2,x4));
	if(choice==2) return(cube(x3,x1,x2,x4));
	if(choice==3) return(cube(x1,x3,x4,x2));
	if(choice==4) return(cube(x3,x1,x4,x2));
	return(cube(x3,x4,x1,x2));
    }


    public static Complex[] cube(double x1,double x2,double x3,double x4) {
	Complex[] z={new Complex(x1,x2-1.0/3),new Complex(x3,x4-1.0/3)};
	return(z);
    }

    public void denomTest(int choice) {
	HALT=false;
	double min=10000;
	Complex[] p={new Complex(1.0/3,0),new Complex(1.0/3,0)};
	long count=0;
	double s=1.0/3;
	for(int i=0;i<2;++i) {
	for(int j=0;j<2;++j) {
	    for(int k=0;k<=1000;++k) {
		for(int l=0;l<=1000;++l) {
		    double x1=2*i*s;  
		    double x2=2*j*s;
		    double x3=2*s*k/1000;
		    double x4=2*s*l/1000;
		    for(int q=0;q<6;++q) {
		      Complex[] z=cube(q,x1,x2,x3,x4);
		      double d=0;
		      if(choice==1) d=SquareTest.normTest1(z[0],z[1]);
		      if(choice==2) d=SquareTest.normTest2(z[0],z[1]);
		      if(min>d) {
			  System.out.println("min "+min);
			  min=d;
		      }
		    }
		}
	    }
	  
	}}
        System.out.println("done");
	HALT=true;
	M.C.repaint();
    }





    public void debug() {
	double x=Math.random();
	double y=Math.random();
	double[] X={x,y};
	Complex[] Z={new Complex(x,0),new Complex(y,0)};
	double[] X1=Penta.gauss(X);
	Complex[] Z1=Penta.gauss(Z);

	System.out.println(X1[0]+" "+X1[1]);
	Z1[0].print();
	Z1[1].print();
    }

}


