import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ColorScheme {

    /**This is the main routine.  It converts an integer
       into a number.*/

    public static int getRGB(int choice,int n) {
	if(choice==0) return(getRGB0(n));
	if(choice==1) return(getRGB1(n));
	if(choice==2) return(getRGB2(n));
	return(getRGB3(n));
    }

    /**This converts a list of 3 numbers (redval,blueval,greenval)
       into a single integer.*/

    public static int convert(int[] a) {
	int n=256*256*a[0]+256*a[1]+a[2];
	return(n);
    }

    /**The individual color schemes.*/

    public static int getRGB0(int k) {
	int n=k%2;
	if(n==0) return(0x000000);
	return(0xffffff);
    }


    public static int getRGB1(int k) {
	int n=k%16;
	int[] a={16*n,16*n,16*n};
	return(convert(a));
    }

    public static int getRGB2(int k) {
	int n=k%16;
	if(n>8) n=16-n;
	int[] a={0,0,0};
	if(n<4) {
           a[2]=60*n;
	   return(convert(a));
	}
	a[2]=255;
	a[1]=60*(n-4);
	return(convert(a));
    }

    public static int getRGB3(int k) {
	int n=k%10;
	if(n==0) return(0x000000);
	if(n==1) return(0xffff00);
	if(n==2) return(0xffaa00);
	if(n==3) return(0xff8800);
	if(n==4) return(0xff2200);
	if(n==5) return(0xdd0000);
	if(n==6) return(0x990000);
	if(n==7) return(0x660066);
	if(n==8) return(0x6600aa);
	if(n==9) return(0x6600ff);
	return(0x000000);
    }




}


