import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends Canvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    Animator A; 
    ControlPanel ACTION,TEST;
    ListenSquare GO,STOP;
    Lever ZOOM,COLOR,NORMALIZE,COORD;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 ZOOM=new Lever(10,40,4,9);
	 COLOR=new Lever(140,40,2,4);
	 NORMALIZE=new Lever(220,40,0,2);
	 GO=new ListenSquare(0,0,30,20,null);GO.on=1;
	 STOP=new ListenSquare(30,0,30,20,null);STOP.on=1;
	 A=new Animator();
	 setPanels();
     }




    public void setPanels() {  
         Color[] C0={new Color(0,90,195),Color.white,Color.white,Color.black,new Color(180,180,180)};
	 String[] ShapeString={"none","similarity","projective","normalize polygon"};

	 String[] ActionString={"real image","complex image","tests","debug","action"};
	 int[] ActionState={1,0,0,0};
         ACTION=new ControlPanel(C0,ActionString,ActionState,4);
	 ACTION.mode=0;

	 String[] TestString={"cube","denom 1","denom 2","tests"};
	 int[] TestState={1,0,0};
         TEST=new ControlPanel(C0,TestString,TestState,3);
	 TEST.mode=0;
    }



   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

   public void drawBG(Graphics2D g) {
        g.setColor(new Color(0,0,100));
        g.fillRect(0,0,getWidth(),getHeight()); 
        g.setColor(Color.white);
        g.drawRect(0,0,getWidth()-1,getHeight()-1); 
   }

    public void drawControls(Graphics2D g) {
	ZOOM.render(g,"zoom",Color.blue);
	COLOR.render(g,"color",Color.blue);
	NORMALIZE.render(g,"normalize",Color.blue);
	if(A.HALT==true) {
	    GO.render(g,new Color(0,180,0));
	    g.setColor(Color.white);
	    g.drawString("go",5,15);
	}
	if(A.HALT==false) {
            STOP.render(g,Color.red);  
            g.setColor(Color.white);
	    g.drawString("stop",35,15);
	}
	ACTION.render(g,0,100,100);
	if(ACTION.mode==2) TEST.render(g,100,100,100);
    }

    public boolean doRun() {
	if(A.HALT==false) return(false);
	A=new Animator(this.M);
        new Thread(A).start();
	return(true);
    }

    public boolean doStop() {
	if(A.HALT==true) return(false);
	A.HALT=true;
	return(true);
    }


    public void setScaling(Point X) {
	ZOOM.process(X);
	int n=ZOOM.val-1;
	double phi=(1+Math.sqrt(5))/2;
	double d=Math.pow(phi,5)/2;
	double e=Math.pow(2,-n);
	M.P.SCALE=Math.pow(d,e);
    }

    public void mouseClicked(MouseEvent e) {
        MouseData J=MouseData.process(e);
	COLOR.process(J.X);
	NORMALIZE.process(J.X);
	ACTION.switchMode(J.X);
	TEST.switchMode(J.X);
	setScaling(J.X);
	if(GO.inside(J.X)==1) doRun();
	if(STOP.inside(J.X)==1) doStop();
	repaint();
	M.P.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
     }



    public void keyPressed(KeyEvent e) {}
    public void keyTyped(KeyEvent e) {
	repaint();
    }
    public void keyReleased(KeyEvent e) {
    }


}

