import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Coords {

    /**This mobius transformation has the action
       1/phi  --> infinity    (attracting fixed pt)
       -phi   --> 0           (symmetric repelling fixed point*)
       -3     --> 1           (asymmetric repelling fixed pt
    **/


    public static double t1(double x) {
	double s5=Math.sqrt(5);
	double a=-2-s5;
	double b=.5*(-7-3*s5);
	double c=.5*(-1-s5);
	double d=1;
	double y=(a*x+b)/(c*x+d);
	return(y);
    }

    /**The inverse of T1*/

    public static double t2(double x) {	
        double s5=Math.sqrt(5);
	double a=3.0/2-7/(2*s5);
	double b=-1/s5;
	double c=-1+2/s5;
	double d=.1*(5-s5);
	double y=(a*x+b)/(c*x+d);
	return(y);
    }

    /**These maps are made by letting the Mobius transformations
       above act on each coordinate.*/

    public static double[] T2(double[] x) {
	double[] y={t2(x[0]),t2(x[1])};
	return(y);
    }

    public static double[] T1(double[] x) {
	double[] y={t1(x[0]),t1(x[1])};
	return(y);
    }
}

