import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class DomainTest {

    /**Returns the number of iterates needed to get the
       point into the unit square.  Presumably the fixed
       point in the unit square is a global attractor.
       Returns 10000 if necessary, to prevent the routine
       from getting hung up.**/

    public static int squareNumber(double[] d) {
	int count=0;
	boolean test=false;
	double[] d2={d[0],d[1]};
	while((count<10000)&&(test==false)) { 
            test=inSquare(d2);
            ++count;
	    d2=Penta.map(d2);
	}
	return(count-1);
    }

    /**This returns the number of iterates needed to
       get the point into the following domain.  Let
       Q be the cube of sidelength 2/3 about the point
       (1/3,1/3).  Let D be the full orbit of Q under
       the Gauss recurrence. Then D is a complex domain
       containing the real unit square, and contained
       within the basin of attraction of the regular
       pentagon class.*/

    public static int domainNumber(Complex[] d) {
	int count=0;
	boolean test=false;
	Complex[] d2={d[0],d[1]};
	while((count<10000)&&(test==false)) { 
            test=inDomain(d2);
            ++count;
	    d2=Penta.map(d2);
	}
	return(count-1);
    }


    /**Tests if the point is in the unit square.*/
    public static boolean inSquare(double[] d) {
	if(d[0]<=0) return(false);
	if(d[0]>=1) return(false);
	if(d[1]<=0) return(false);
	if(d[1]>=1) return(false);
	return(true);
    }


    public static boolean inDomain(Complex[] z) {
	Complex[] w={z[0],z[1]};
	for(int i=0;i<5;++i) {
	    if(inSquareComplex(w)==true) return(true);
	    w=Penta.gauss(w);
	}
	return(false);
    }


    public static boolean inSquareComplex(Complex[] z) {
	Complex w=new Complex(1.0/3,0);
	Complex[] p={w,w};
	double d=SquareTest.infinityDist(z,p);
	if(d<1.0/3) return(true);
	return(false);
    }


}

