import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.*;
import java.awt.image.*;


public class IterationCanvas extends ScaleCanvas implements KeyListener,MouseListener, MouseMotionListener {
    Manager M;
    Color[] COLOR=new Color[20000];
    Complex[] POINT=new Complex[20000];
    int COUNT;
    Point JX;
    BufferedImage IMAGE;
  

     public IterationCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(200,200,120);
	 COUNT=0;

     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBg(g);
      drawPoints(g);
   }

   public void drawBg(Graphics2D g) {
       Color C=Color.black;
	  g.setColor(C);
          g.fillRect(0,0,getWidth(),getHeight());
	  PolyVector P=PolyVector.unitSquare();
	  GeneralPath gp=P.toGeneralPath();
	  drawMyPath(g,gp,new Color(20,20,20),new Color(100,100,100));
	  gp.reset();
	  gp.moveTo(-30,0);
	  gp.lineTo(30,0);
	  gp.moveTo(0,-30);
	  gp.lineTo(0,30);
	  gp.moveTo(-30,-30);
	  gp.lineTo(30,30);
	  gp=transform(gp);
	  g.setColor(new Color(50,50,50));
	  g.draw(gp);

	  gp.reset();
	  float phi=(float)(.5+Math.sqrt(5)/2);
	  gp.moveTo(-3,-3);
	  gp.lineTo(-phi,-phi); 
          gp=transform(gp);
	  g.setColor(new Color(0,80,150));
	  g.draw(gp);

	  gp.reset();
	  gp.moveTo(-3,-3);
	  gp.lineTo(-3,-1.0/2);
	  gp.lineTo(-1.0/2,-8);
	  gp.lineTo(-8,-1.0/2);
	  gp.lineTo(-1.0/2,-3);
	  gp.closePath();
          gp=transform(gp);
	  g.setColor(new Color(100,0,200));
	  g.draw(gp);

	  g.setColor(Color.white);
	  g.drawRect(0,0,getWidth()-1,getHeight()-1);
   }

    public void drawPoints(Graphics2D g) {
	int k=100;
	double r=Math.pow(.5,k);
	for(int i=0;i<COUNT;++i) {
	    fillPoint(g,POINT[i],r,COLOR[i],16);
	}
    }

    public void drawMyPath(Graphics2D g,GeneralPath gp,Color C1,Color C2) {
	gp=transform(gp);
	g.setColor(C1);
        g.fill(gp);
        g.setColor(C2);
	g.draw(gp);
    }


    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	int mode=J.mode;
	if(mode!=2) {
	    doScale(e,M);
	}
	if(mode==2) SOURCE=unTransform(J.X);
	repaint();
	doTest();
    }

    public void doTest() {
    }

    public void doMouseClick(int mode) {
	if(mode!=2) {
	    doScale(mode,JX);
	}
	if(mode==2) SOURCE=unTransform(JX);
	repaint();
    }
    public void mousePressed(MouseEvent e) { }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=J.X;
     }

     public void mouseDragged(MouseEvent e) {
     }


    public void keyPressed(KeyEvent e) {
	int test=-100;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;   //zoom in
	if(ch=='x') {
            test=2; 
	}   //select point
	if(ch=='c') test=3;   //zoom out
        doMouseClick(test);
	repaint();
    }


    public void keyTyped(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {
    }



}

