import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;
import java.awt.*;
import java.awt.image.*;


public class Navigator extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    BufferedImage IMAGE;
    Point JX;
  

     public Navigator() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(150,150,120);
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      drawBG(g);
      drawSource(g);
      drawCoords(g);
      drawFrame(g);
   }

  public void drawBG(Graphics2D g) {
    g.setColor(Color.black);
    g.fillRect(0,0,getWidth(),getHeight());
    GeneralPath gp=new GeneralPath();
    gp.moveTo(-100,0);
    gp.lineTo(100,0);
    gp.moveTo(0,100);
    gp.lineTo(0,-100);
    gp=transform(gp);
    g.setColor(Color.blue);
    g.draw(gp); 
    gp.reset();
    gp.moveTo(-1,-1);
    gp.lineTo(-1,1);
    gp.lineTo(1,1);
    gp.lineTo(1,-1);
    gp.closePath();
    gp=transform(gp);
    g.setColor(Color.red);
    g.draw(gp);
  }

    public void drawSource(Graphics2D g) {
	GeneralPath gp=new GeneralPath();
	gp.moveTo((float)(SOURCE.x-10),(float)(SOURCE.y-10));
	gp.lineTo((float)(SOURCE.x+10),(float)(SOURCE.y+10));
	gp.lineTo((float)(SOURCE.x+10),(float)(SOURCE.y-10));
	gp.lineTo((float)(SOURCE.x-10),(float)(SOURCE.y+10));
        gp=transform(gp);
        g.setColor(Color.green);
        g.draw(gp); 
    }

    public void drawCoords(Graphics2D g) {
       g.setFont(new Font("Helvetica",Font.PLAIN,12));
       g.setColor(Color.white);
       Double X=new Double(M.P.SOURCE.x);
       Double Y=new Double(M.P.SOURCE.y);
       g.drawString(X.toString()+"    "+Y.toString(),5,15);
       int[] IX=Golden.recognize(M.P.SOURCE.x,200);
       int[] IY=Golden.recognize(M.P.SOURCE.y,200);
       Integer I1=new Integer(IX[0]);
       Integer I2=new Integer(IX[1]);
       Integer I3=new Integer(IY[0]);
       Integer I4=new Integer(IY[1]);
       System.out.println(I1.toString()+" "+I2.toString());
       System.out.println(I3.toString()+" "+I4.toString());
    }

    public void drawFrame(Graphics2D g) {
       g.setColor(Color.white);
       g.drawRect(0,0,getWidth()-1,getHeight()-1);
    }

    public void mouseDragged(MouseEvent e) { }

    public void mouseMoved(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	JX=J.X;
    }

    public void mousePressed(MouseEvent e) { }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {}   

     public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
     }

     public void doMouseClick(int mode) {
	if(mode==1) scaleUp(JX,-1);
	if(mode==3) scaleUp(JX,+1);
	if(mode==2) SOURCE=unTransform(JX);
	repaint();
     }

    public void keyPressed(KeyEvent e) {
	int test=-100;
	char ch=e.getKeyChar();
	if(ch=='z') test=1;   //zoom in
	if(ch=='x') test=2;
	if(ch=='c') test=3;   //zoom out
        doMouseClick(test);
	repaint();
    }

    public void keyTyped(KeyEvent e) {}
    public void keyReleased(KeyEvent e) {
    }
}