import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class Penta {

    /**This does the basic map in real coords*/

  public static double[] map(double[] x) {
	double w1=coord1(x[0],x[1]);
	double w2=coord1(x[1],x[0]);
	double[] w={w1,w2};
	return(w);
    }


    public static double coord1(double x,double y) {
	double d=(-3+2*x*y+x*y*y);
	d=d*(6-x-6*x*y+x*x*y*y);
	d=d/(-5+x-y+4*x*y+x*y*y);
	d=d/(6-y-6*x*y+x*x*y*y);
	return(d);
    }


    /**This does the basic rational map in cpmplex coords*/
    public static Complex[] map(Complex[] x) {
	Complex w1=coord1(x[0],x[1]);
	Complex w2=coord1(x[1],x[0]);
	Complex[] w={w1,w2};
	return(w);
    }

    /**First coordinate of rational map for pentas*/
    public static Complex coord1(Complex x,Complex y) {

	Complex z1=new Complex(-3,0);
	Complex z2=Complex.times(new Complex(2,0),Complex.times(x,y));
	Complex z3=Complex.times(Complex.times(x,y),y);
	Complex w1=Complex.plus(Complex.plus(z1,z2),z3);

	z1=new Complex(6,0);
	z2=Complex.times(z1,Complex.times(x,y));
	z3=Complex.times(Complex.times(Complex.times(x,x),y),y);
	Complex w2=Complex.minus(z1,x);
	w2=Complex.minus(w2,z2);
	w2=Complex.plus(w2,z3);

	z1=new Complex(-5,0);
	z2=Complex.times(new Complex(4,0),Complex.times(x,y));
	z3=Complex.times(Complex.times(x,y),y);
	Complex w3=Complex.plus(z1,x);
	w3=Complex.minus(w3,y);
	w3=Complex.plus(w3,z2);
	w3=Complex.plus(w3,z3);

	z1=new Complex(6,0);
	z2=Complex.times(z1,Complex.times(x,y));
	z3=Complex.times(Complex.times(Complex.times(x,x),y),y);
	Complex w4=Complex.minus(z1,y);
	w4=Complex.minus(w4,z2);
	w4=Complex.plus(w4,z3);

	Complex w5=Complex.divide(Complex.times(w1,w2),Complex.times(w3,w4));
	return(w5);
    }

    /**Here is the Gauss recurrence.  It commutes with the map*/

    public static double[] gauss(double[] d) {
	double[] e={d[1],(1-d[0])/(1-d[0]*d[1])};
	return(e);
    }

    /**Here is the complex version of the Gauss recurrence*/

    public static Complex[] gauss(Complex[] z) {
	Complex w1=Complex.minus(new Complex(1,0),z[0]);
	Complex w2=Complex.times(z[0],z[1]);
	Complex w3=Complex.minus(new Complex(1,0),w2);
	Complex w4=Complex.divide(w1,w3);
	Complex[] w={z[1],w4};
	return(w);
    }


}

